/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.port.factory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoLocal;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoPK;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoUtil;
import com.clustercontrol.port.ejb.entity.MonitorProtocolMasterLocal;
import com.clustercontrol.port.ejb.entity.MonitorProtocolMasterUtil;
import com.clustercontrol.port.util.ReachAddressProtocol;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorPort
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorPort.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected static final ArrayList<String> m_attributeList = new ArrayList();
    protected MonitorPortInfoLocal m_port = null;
    protected int m_portNo;
    protected int m_runCount = 1;
    protected int m_runInterval = 1000;
    protected int m_portTimeout;
    protected String m_serviceId;
    protected MonitorProtocolMasterLocal m_protocol = null;
    protected String m_message = null;
    protected String m_unKnownMessage = null;
    protected String m_messageOrg = null;
    protected long m_response = 0L;
    ReachAddressProtocol m_reachability = null;

    public RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException {
        return new RunMonitorPort();
    }

    public boolean collect(String facilityId) {
        this.m_nodeDate = this.m_now.getTime();
        this.m_message = "";
        this.m_messageOrg = "";
        this.m_response = 0L;
        if (this.m_reachability == null) {
            try {
                this.m_protocol = MonitorProtocolMasterUtil.getLocalHome().findByPrimaryKey(this.m_serviceId);
                String protocolClassName = "";
                if (this.m_protocol.getClassName() != null) {
                    protocolClassName = this.m_protocol.getClassName();
                }
                Class<?> cls = Class.forName(protocolClassName);
                this.m_reachability = (ReachAddressProtocol)cls.newInstance();
                this.m_reachability.setPortNo(this.m_portNo);
                this.m_reachability.setSentCount(this.m_runCount);
                this.m_reachability.setSentInterval(this.m_runInterval);
                this.m_reachability.setTimeout(this.m_portTimeout);
            }
            catch (NamingException e) {
            }
            catch (FinderException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        try {
            HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityId, m_attributeList);
            Integer ipProtNum = (Integer)facilityAttrMap.get("ipProtocolNumber");
            String ipNetworkNumber = "";
            String nodeName = (String)facilityAttrMap.get("ccNodeName");
            ipNetworkNumber = ipProtNum != null && ipProtNum == 6 ? (String)facilityAttrMap.get("ccIpNetworkNumberV6") : (String)facilityAttrMap.get("ipNetworkNumber");
            boolean result = this.m_reachability.isReachable(ipNetworkNumber, nodeName);
            this.m_message = this.m_reachability.getMessage();
            this.m_messageOrg = this.m_reachability.getMessageOrg();
            if (result) {
                this.m_response = this.m_reachability.getResponse();
            }
            return result;
        }
        catch (FinderException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.port.4");
            this.m_messageOrg = e.getMessage();
            return false;
        }
        catch (NamingException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.port.4");
            this.m_messageOrg = e.getMessage();
            return false;
        }
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorPortInfoPK pk = new MonitorPortInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_port = MonitorPortInfoUtil.getLocalHome().findByPrimaryKey(pk);
        if (this.m_port.getPortNo() != null) {
            this.m_portNo = this.m_port.getPortNo();
        }
        if (this.m_port.getRunCount() != null) {
            this.m_runCount = this.m_port.getRunCount();
        }
        if (this.m_port.getRunInterval() != null) {
            this.m_runInterval = this.m_port.getRunInterval();
        }
        if (this.m_port.getTimeout() != null) {
            this.m_portTimeout = this.m_port.getTimeout();
        }
        if (this.m_port.getServiceId() != null) {
            this.m_serviceId = this.m_port.getServiceId();
        }
    }

    public int getCheckResult(boolean ret) {
        int result = -1;
        MonitorNumericValueInfo info = null;
        if (ret) {
            info = (MonitorNumericValueInfo)this.m_judgementInfoList.get(3);
            result = (double)this.m_response >= info.getThresholdLowerLimit() && (double)this.m_response <= info.getThresholdUpperLimit() ? 3 : ((double)this.m_response >= (info = (MonitorNumericValueInfo)this.m_judgementInfoList.get(2)).getThresholdLowerLimit() && (double)this.m_response <= info.getThresholdUpperLimit() ? 2 : 0);
        }
        return result;
    }

    public String getMessageId(int id) {
        if (id == 3) {
            return MESSAGE_ID_INFO;
        }
        if (id == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (id == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int id) {
        return this.m_message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
        super.run(monitorTypeId, monitorId);
    }

    static {
        m_attributeList.add("ccNodeName");
        m_attributeList.add("ipProtocolNumber");
        m_attributeList.add("ipNetworkNumber");
        m_attributeList.add("ccIpNetworkNumberV6");
    }
}

