/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;
import com.clustercontrol.collectiverun.factory.DeleteMaster;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyMaster {
    protected static Log m_log = LogFactory.getLog(ModifyMaster.class);

    public void update(ItemInfo info, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException {
        if (info == null || parentInfo == null) {
            return;
        }
        if (!(info instanceof TypeInfo || info instanceof CommandInfo || info instanceof CommandParameterInfo || info instanceof ParameterInfo || info instanceof ParameterSelectInfo || parentInfo instanceof CommandInfo || parentInfo instanceof TypeInfo)) {
            return;
        }
        if (info.getType() == 0) {
            this.updateType((TypeInfo)info);
        } else if (info.getType() == 1) {
            this.updateCommand((CommandInfo)info, ((TypeInfo)parentInfo).getId());
        } else if (info.getType() == 2) {
            this.updateCommandParameter((CommandParameterInfo)info, ((CommandInfo)parentInfo).getId());
        } else if (info.getType() == 3) {
            this.updateParameter((ParameterInfo)info);
        } else if (info.getType() == 4) {
            this.updateParameterSelect((ParameterSelectInfo)info);
        }
    }

    public void updateType(TypeInfo info) throws NamingException, CreateException {
        boolean create = false;
        CRunTypeMstLocal type = null;
        try {
            type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(info.getId());
        }
        catch (FinderException e) {
            create = true;
        }
        if (create) {
            CRunTypeMstUtil.getLocalHome().create(info.getId(), info.getName(), info.getOrderNo());
        } else {
            type.setName_id(info.getName());
            type.setOrder_no(info.getOrderNo());
            type = null;
        }
    }

    public void updateCommand(CommandInfo info, String typeId) throws NamingException, CreateException {
        boolean create = false;
        CRunCmdMstLocal command = null;
        try {
            command = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(info.getId());
        }
        catch (FinderException e) {
            create = true;
        }
        if (create) {
            CRunCmdMstUtil.getLocalHome().create(info.getId(), typeId, info.getOrderNo(), info.getName(), info.getCommandType(), info.getCommand());
        } else {
            command.setName_id(info.getName());
            command.setOrder_no(info.getOrderNo());
            command.setCommand(info.getCommand());
            command.setCommand_type(info.getCommandType());
            command = null;
        }
        if (info.getEndStatus() != null && info.getEndStatus() instanceof ArrayList) {
            for (int i = 0; i < info.getEndStatus().size(); ++i) {
                EndStatusInfo endStatus = info.getEndStatus().get(i);
                if (!(endStatus instanceof EndStatusInfo)) continue;
                boolean endCreate = false;
                CRunEndMstLocal end = null;
                try {
                    end = CRunEndMstUtil.getLocalHome().findByPrimaryKey(new CRunEndMstPK(info.getId(), endStatus.getEndStatus()));
                }
                catch (FinderException e) {
                    endCreate = true;
                }
                if (endCreate) {
                    CRunEndMstUtil.getLocalHome().create(info.getId(), endStatus.getEndStatus(), endStatus.getStartRangeValue(), endStatus.getEndRangeValue());
                    continue;
                }
                end.setEnd_value_from(endStatus.getStartRangeValue());
                end.setEnd_value_to(endStatus.getEndRangeValue());
                end = null;
            }
        }
    }

    public void updateCommandParameter(CommandParameterInfo info, String commandId) throws NamingException, CreateException {
        boolean create = false;
        CRunCmdParamMstLocal commandParameter = null;
        try {
            commandParameter = CRunCmdParamMstUtil.getLocalHome().findByPrimaryKey(new CRunCmdParamMstPK(commandId, info.getId()));
        }
        catch (FinderException e) {
            create = true;
        }
        if (create) {
            CRunCmdParamMstUtil.getLocalHome().create(commandId, info.getId(), info.getOrderNo(), info.getPrefix());
        } else {
            commandParameter.setParam_prefix(info.getPrefix());
            commandParameter.setOrder_no(info.getOrderNo());
            commandParameter = null;
        }
    }

    public void updateParameter(ParameterInfo info) throws NamingException, CreateException {
        boolean create = false;
        CRunParamMstLocal parameter = null;
        try {
            parameter = CRunParamMstUtil.getLocalHome().findByPrimaryKey(info.getId());
        }
        catch (FinderException e) {
            create = true;
        }
        if (create) {
            CRunParamMstUtil.getLocalHome().create(info.getId(), info.getName(), info.getParamType());
        } else {
            parameter.setName_id(info.getName());
            parameter.setParam_type(info.getParamType());
            parameter = null;
        }
    }

    public void updateParameterSelect(ParameterSelectInfo info) throws NamingException, CreateException, RemoveException {
        boolean create = false;
        CRunParamSelectMstLocal select = null;
        try {
            select = CRunParamSelectMstUtil.getLocalHome().findByPrimaryKey(new CRunParamSelectMstPK(info.getId(), info.getOrderNo()));
        }
        catch (FinderException e) {
            create = true;
        }
        if (create) {
            CRunParamSelectMstUtil.getLocalHome().create(info.getId(), info.getOrderNo(), info.getName(), info.getValue());
        } else {
            select.setName_id(info.getName());
            select.setParam_value(info.getValue());
            select = null;
        }
    }

    public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException, FinderException {
        int orderNo1 = info1.getOrderNo();
        int orderNo2 = info2.getOrderNo();
        if (info1.getType() == 4) {
            DeleteMaster delete = new DeleteMaster();
            delete.delete(info1, parentInfo);
            delete.delete(info2, parentInfo);
            info1.setOrderNo(orderNo2);
            this.update(info1, parentInfo);
            info2.setOrderNo(orderNo1);
            this.update(info2, parentInfo);
        } else {
            info1.setOrderNo(orderNo2);
            this.update(info1, parentInfo);
            info2.setOrderNo(orderNo1);
            this.update(info2, parentInfo);
        }
    }
}

