/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxrpc;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl;

public class WSAddressingClientHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger(WSAddressingClientHandler.class);
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;
    private static QName[] HEADERS;

    public QName[] getHeaders() {
        return HEADERS;
    }

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
    }

    public boolean handleRequest(MessageContext msgContext) {
        SOAPAddressingProperties addrProps;
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleRequest");
        }
        if ((addrProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound")) != null) {
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            addrProps.writeHeaders(soapMessage);
        } else {
            addrProps = (SOAPAddressingPropertiesImpl)ADDR_BUILDER.newAddressingProperties();
            msgContext.setProperty("javax.xml.ws.addressing.context.outbound", (Object)addrProps);
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleResponse");
        }
        try {
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            if (soapMessage.getSOAPPart().getEnvelope() != null) {
                SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
                SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
                addrProps.readHeaders(soapMessage);
                msgContext.setProperty("javax.xml.ws.addressing.context.inbound", (Object)addrProps);
            }
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot handle response", (Throwable)ex);
        }
        return true;
    }

    static {
        HEADERS = new QName[2];
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
        WSAddressingClientHandler.HEADERS[0] = ADDR_CONSTANTS.getActionQName();
        WSAddressingClientHandler.HEADERS[1] = ADDR_CONSTANTS.getToQName();
    }
}

