/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeKeeper
implements Runnable {
    protected static Log m_log = LogFactory.getLog(TimeKeeper.class);
    long TIMEOUT = 15000L;
    long timeout;
    long timerStart;
    boolean ldapResponse = false;
    Thread parent = Thread.currentThread();
    Thread myThread = null;

    public TimeKeeper() {
        this.timeout = this.TIMEOUT;
    }

    public TimeKeeper(long timout) {
        this.timeout = timout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TimeKeeper timeKeeper = this;
        synchronized (timeKeeper) {
            if (this.ldapResponse) {
                return;
            }
            this.myThread = Thread.currentThread();
        }
        this.timerStart = System.currentTimeMillis();
        long waitTime = this.timeout;
        while (waitTime > 0L) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException ie) {
                TimeKeeper timeKeeper2 = this;
                synchronized (timeKeeper2) {
                    if (this.ldapResponse) {
                        break;
                    }
                }
            }
            waitTime = this.timeout - (System.currentTimeMillis() - this.timerStart);
        }
        TimeKeeper timeKeeper3 = this;
        synchronized (timeKeeper3) {
            if (!this.ldapResponse) {
                m_log.error((Object)("LDAP Connection Timeout. [ " + this.timeout + " ms ]"));
                this.parent.interrupt();
            }
            this.myThread = null;
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TimeKeeper timeKeeper = this;
        synchronized (timeKeeper) {
            this.ldapResponse = true;
            if (this.myThread != null) {
                this.myThread.interrupt();
            }
        }
    }
}

