/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao.cache;

import com.clustercontrol.repository.dao.DeviceInfoDAOImpl;
import com.clustercontrol.repository.ejb.entity.DeviceInfoBean;
import com.clustercontrol.repository.ejb.entity.DeviceInfoPK;
import com.clustercontrol.repository.util.RepositoryCacheProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedDeviceInfoDAOImpl
extends DeviceInfoDAOImpl {
    protected static Log m_log = LogFactory.getLog(CachedDeviceInfoDAOImpl.class);
    private Boolean m_isInit = false;
    private static HashMap<String, Collection> m_facilityIdCache = null;
    private static List<HashMap> m_cacheMapList = new ArrayList<HashMap>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Boolean bl = this.m_isInit;
        synchronized (bl) {
            if (this.m_isInit.booleanValue()) {
                return;
            }
            if (RepositoryCacheProperties.getProperties("common.repository.cache.device.facilityid") > 0) {
                m_facilityIdCache = new HashMap();
                m_cacheMapList.add(m_facilityIdCache);
                m_log.info((Object)"DeviceInfoDAO findByFacilityId : enable");
            }
            this.m_isInit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCacheAll() {
        List<HashMap> list = m_cacheMapList;
        synchronized (list) {
            Iterator<HashMap> itr = m_cacheMapList.iterator();
            while (itr.hasNext()) {
                HashMap map;
                HashMap hashMap = map = itr.next();
                synchronized (hashMap) {
                    m_log.debug((Object)("clearCache() clear : " + map.size()));
                    map.clear();
                }
            }
        }
    }

    public void store(DeviceInfoBean ejb) throws EJBException {
        m_log.debug((Object)"store()");
        super.store(ejb);
        CachedDeviceInfoDAOImpl.clearCacheAll();
    }

    public void remove(DeviceInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)"remove()");
        super.remove(pk);
        CachedDeviceInfoDAOImpl.clearCacheAll();
    }

    public DeviceInfoPK create(DeviceInfoBean ejb) throws CreateException, EJBException {
        m_log.debug((Object)"create()");
        DeviceInfoPK pk = super.create(ejb);
        CachedDeviceInfoDAOImpl.clearCacheAll();
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        if (m_facilityIdCache == null) {
            return super.findByFacilityId(facilityId);
        }
        HashMap<String, Collection> hashMap = m_facilityIdCache;
        synchronized (hashMap) {
            if (m_facilityIdCache.containsKey(facilityId)) {
                return m_facilityIdCache.get(facilityId);
            }
        }
        Collection ret = super.findByFacilityId(facilityId);
        HashMap<String, Collection> hashMap2 = m_facilityIdCache;
        synchronized (hashMap2) {
            m_log.debug((Object)("findByFacilityId(String facilityId) put : " + facilityId + "  entry size : " + ret.size() + "  total entry : " + m_facilityIdCache.size()));
            m_facilityIdCache.put(facilityId, ret);
        }
        return ret;
    }
}

