/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.factory;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifySchedule {
    protected static Log m_log = LogFactory.getLog(ModifySchedule.class);

    public boolean addSchedule(String monitorId, String collectorId, String parentFacilityId, int interval, List colletorItemList, int valid) {
        try {
            RecordCollectorData data = new RecordCollectorData();
            data.setCollectorID(collectorId);
            data.setCollectorType(3);
            data.setLabel(monitorId);
            data.setFacilityID(parentFacilityId);
            data.setIntervalSec(interval);
            data.setPeriodMin(-1);
            Repository repository = new Repository();
            FacilityTreeItem facilityTree = repository.getFacilityTree(parentFacilityId);
            data.setFacilityTree(facilityTree);
            if (facilityTree == null) {
                return false;
            }
            if (valid == 1) {
                CollectorHome home = JNDIConnectionManager.getCollectorHome();
                Collector myBean = home.create(data, colletorItemList);
                myBean.startCollect();
            }
            return true;
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("PERF", "performance");
            apllog.put("SYS", "001");
            m_log.debug((Object)("addSchedule():" + e.getMessage()));
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("PERF", "performance");
            apllog.put("SYS", "001");
            m_log.debug((Object)("addSchedule():" + e.getMessage()));
        }
        catch (RemoteException e) {
            AplLogger apllog = new AplLogger("PERF", "performance");
            apllog.put("SYS", "001");
            m_log.debug((Object)("addSchedule():" + e.getMessage()));
        }
        return false;
    }
}

