/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.ejb.session;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.factory.AddMonitorPerformance;
import com.clustercontrol.performance.monitor.factory.DeleteMonitorPerformance;
import com.clustercontrol.performance.monitor.factory.ModifyMonitorPerformance;
import com.clustercontrol.performance.monitor.factory.SelectMonitorPerformance;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorPerfControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorPerfControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addPerformance(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddMonitorPerformance addPerf = new AddMonitorPerformance();
        return addPerf.add(info, pri.getName());
    }

    public boolean modifyPerformance(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMonitorPerformance modifyPerf = new ModifyMonitorPerformance();
        return modifyPerf.modify(info, pri.getName());
    }

    public boolean deletePerformance(String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
        DeleteMonitorPerformance delPerf = new DeleteMonitorPerformance();
        return delPerf.delete("MON_PRF", monitorId);
    }

    public MonitorInfo getPerformance(String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorPerformance selectPerf = new SelectMonitorPerformance();
        MonitorInfo info = selectPerf.getMonitor("MON_PRF", monitorId);
        return info;
    }

    public ArrayList getPerformanceList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorPerformance selectPerf = new SelectMonitorPerformance();
        ArrayList list = selectPerf.getMonitorList("MON_PRF");
        return list;
    }

    public ArrayList getPerformanceListTableDefine(Locale locale) {
        SelectMonitorPerformance selectPerf = new SelectMonitorPerformance();
        ArrayList tableDefine = selectPerf.getMonitorListTableDefine(locale);
        return tableDefine;
    }
}

