/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import java.util.Properties;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILFactory;
import org.jboss.mq.il.oil2.OIL2ClientILService;
import org.jboss.mq.il.oil2.OIL2ServerIL;

public final class OIL2ServerILFactory
implements ServerILFactory {
    private static final Logger log = Logger.getLogger(OIL2ServerILFactory.class);
    public static final String SERVER_IL_FACTORY = OIL2ServerILFactory.class.getName();
    public static final String CLIENT_IL_SERVICE = OIL2ClientILService.class.getName();
    public static final String OIL2_ADDRESS_KEY = "OIL2_ADDRESS_KEY";
    public static final String OIL2_PORT_KEY = "OIL2_PORT_KEY";
    public static final String OIL2_TCPNODELAY_KEY = "OIL2_TCPNODELAY_KEY";
    private ServerIL serverIL;

    public void init(Properties props) throws Exception {
        String address = props.getProperty(OIL2_ADDRESS_KEY);
        if (address == null) {
            throw new JMSException("A required connection property was not set: OIL2_ADDRESS_KEY");
        }
        String t = props.getProperty(OIL2_PORT_KEY);
        if (t == null) {
            throw new JMSException("A required connection property was not set: OIL2_PORT_KEY");
        }
        int port = Integer.parseInt(t);
        boolean enableTcpNoDelay = false;
        t = props.getProperty(OIL2_TCPNODELAY_KEY);
        if (t != null) {
            enableTcpNoDelay = t.equals("yes");
        }
        String clientSocketFactoryName = null;
        this.serverIL = new OIL2ServerIL(address, port, clientSocketFactoryName, enableTcpNoDelay);
    }

    public ServerIL getServerIL() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Providing ServerIL: " + this.serverIL);
        }
        return this.serverIL;
    }
}

