/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.SeriesChangeEvent;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;

public class TaskSeriesCollection
extends AbstractSeriesDataset
implements GanttCategoryDataset {
    private List keys = new ArrayList();
    private List data = new ArrayList();

    public String getSeriesName(int series) {
        TaskSeries ts = (TaskSeries)this.data.get(series);
        return ts.getName();
    }

    public int getSeriesCount() {
        return this.getRowCount();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.keys.size();
    }

    public List getRowKeys() {
        return this.data;
    }

    public List getColumnKeys() {
        return this.keys;
    }

    public Comparable getColumnKey(int item) {
        return (Comparable)this.keys.get(item);
    }

    public int getColumnIndex(Comparable columnKey) {
        return this.keys.indexOf(columnKey);
    }

    public int getRowIndex(Comparable rowKey) {
        return this.data.indexOf(rowKey);
    }

    public Comparable getRowKey(int index) {
        TaskSeries series = (TaskSeries)this.data.get(index);
        return series.getName();
    }

    public void add(TaskSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("XYSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        Iterator iterator = series.getTasks().iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            String key = task.getDescription();
            int index = this.keys.indexOf(key);
            if (index >= 0) continue;
            this.keys.add(key);
        }
        this.fireDatasetChanged();
    }

    public void remove(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("TaskSeriesCollection.remove(...): index outside valid range.");
        }
        TaskSeries ts = (TaskSeries)this.data.get(series);
        ts.removeChangeListener(this);
        this.data.remove(series);
        this.fireDatasetChanged();
    }

    public void remove(TaskSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("TaskSeriesCollection.remove(...): cannot remove null series.");
        }
        if (this.data.contains(series)) {
            series.removeChangeListener(this);
            this.data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeAll() {
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TaskSeries series = (TaskSeries)iterator.next();
            series.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getValue(row, column);
    }

    public Number getValue(int row, int column) {
        return this.getStartValue(row, column);
    }

    public Number getStartValue(Comparable rowKey, Comparable columnKey) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getStartValue(row, column);
    }

    public Number getStartValue(int row, int column) {
        Long result = null;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            result = new Long(task.getDuration().getStart().getTime());
        }
        return result;
    }

    public Number getEndValue(Comparable rowKey, Comparable columnKey) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getEndValue(row, column);
    }

    public Number getEndValue(int row, int column) {
        Long result = null;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            result = new Long(task.getDuration().getEnd().getTime());
        }
        return result;
    }

    public Number getPercentComplete(int row, int column) {
        Double result = null;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            result = task.getPercentComplete();
        }
        return result;
    }

    public Number getPercentComplete(Comparable rowKey, Comparable columnKey) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getPercentComplete(row, column);
    }

    public int getSubIntervalCount(int row, int column) {
        int result = 0;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            result = task.getSubtaskCount();
        }
        return result;
    }

    public int getSubIntervalCount(Comparable rowKey, Comparable columnKey) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getSubIntervalCount(row, column);
    }

    public Number getStartValue(int row, int column, int subinterval) {
        Long result = null;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            Task subtask = task.getSubtask(subinterval);
            result = new Long(subtask.getDuration().getStart().getTime());
        }
        return result;
    }

    public Number getStartValue(Comparable rowKey, Comparable columnKey, int subinterval) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getStartValue(row, column, subinterval);
    }

    public Number getEndValue(int row, int column, int subinterval) {
        Long result = null;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            Task subtask = task.getSubtask(subinterval);
            result = new Long(subtask.getDuration().getEnd().getTime());
        }
        return result;
    }

    public Number getEndValue(Comparable rowKey, Comparable columnKey, int subinterval) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getStartValue(row, column, subinterval);
    }

    public Number getPercentComplete(int row, int column, int subinterval) {
        Double result = null;
        TaskSeries series = (TaskSeries)this.data.get(row);
        int tasks = series.getItemCount();
        if (column < tasks) {
            Task task = series.get(column);
            Task subtask = task.getSubtask(subinterval);
            result = subtask.getPercentComplete();
        }
        return result;
    }

    public Number getPercentComplete(Comparable rowKey, Comparable columnKey, int subinterval) {
        int row = this.getRowIndex(rowKey);
        int column = this.getColumnIndex(columnKey);
        return this.getPercentComplete(row, column, subinterval);
    }

    public void seriesChanged(SeriesChangeEvent event) {
        this.refreshKeys();
        this.fireDatasetChanged();
    }

    private void refreshKeys() {
        this.keys.clear();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            TaskSeries series = (TaskSeries)this.data.get(i);
            Iterator iterator = series.getTasks().iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                String key = task.getDescription();
                int index = this.keys.indexOf(key);
                if (index >= 0) continue;
                this.keys.add(key);
            }
        }
    }
}

