/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.composite;

import java.util.ArrayList;

//import org.eclipse.jface.viewers.ISelectionChangedListener;
//import org.eclipse.jface.viewers.SelectionChangedEvent;
//import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.GetScopeList;
import com.clustercontrol.repository.action.GetScopeListTableDefine;
import com.clustercontrol.repository.bean.ScopeListTableDefine;
import com.clustercontrol.util.Messages;

/**
 * スコープ登録一覧コンポジットクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeListComposite extends Composite {

    // ----- instance フィールド ----- //
	
	protected FacilityTreeItem m_facilityTreeItem = null;
	protected FacilityTreeItem m_selectFacilityTreeItem = null;

    /** テーブルビューア */
    private CommonTableViewer tableViewer = null;

    /** 全件ラベル */
    private Label totalLabel = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent
     *            親のコンポジット
     * @param style
     *            スタイル
     */
    public ScopeListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance メソッド ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        this.totalLabel = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.totalLabel.setLayoutData(gridData);

        // テーブルビューアの作成
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetScopeListTableDefine.get(),
                ScopeListTableDefine.SORT_COLUMN_INDEX,ScopeListTableDefine.SORT_COLUMN_INDEX_SECOND,
                ScopeListTableDefine.SORT_ORDER);
        
//        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
//            public void selectionChanged(SelectionChangedEvent event) {
//                StructuredSelection selection = (StructuredSelection) event.getSelection();
//                
//                // 選択アイテムを取得
//        		ArrayList item = (ArrayList)selection.getFirstElement();
//        		
//        		if(item instanceof ArrayList){
//        			String facilityId = (String)item.get(ScopeListTableDefine.FACILITY_ID);
//
//        			FacilityTreeItem[] items = getFacilityTreeItem().getChildren();
//        			for(int i = 0; i < items.length; i++){
//    					if(facilityId.equals(items[i].getData().getFacilityId())){
//    						m_selectFacilityTreeItem = items[i];
//    						break;
//    					}	
//    				}
//        		}
//            }
//        });
    }

    /**
     * スコープ一覧を表示します。
     * 
     * @param item
     *            選択されたFacilityTreeItem
     */
    public void update(FacilityTreeItem item) {
    	ArrayList list = null;
    	if (item instanceof FacilityTreeItem) {
    		m_facilityTreeItem = item;
    		
    		String facilityId = item.getData().getFacilityId();
    		int type = item.getData().getType();
    		if (type != FacilityConstant.TYPE_NODE) {
    			list = new GetScopeList().getScopeList(facilityId);
    		}
    	}
    	
    	if(list == null)
    		list = new ArrayList();
    	
    	this.tableViewer.setInput(list);
    	
    	// 件数表示
    	Object[] args = { String.valueOf(list.size()) };
    	this.totalLabel.setText(Messages.getString("records", args));
    }

    /**
     * tableViewerを返します。
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }
    /**
     * このコンポジットが利用するテーブルを返します。
     * 
     * @return テーブル
     */
    public Table getTable() {
        return this.tableViewer.getTable();
    }
    /**
     * 選択ファシリティツリーアイテムを設定します。
     * 
     * @param facilityTreeItem ファシリティツリーアイテム
     */
    public void setSelectFacilityTreeItem(FacilityTreeItem facilityTreeItem) {
    	m_selectFacilityTreeItem = facilityTreeItem;
    }
	/**
	 * @return 選択されているアイテムを返します。
	 */
	public FacilityTreeItem getSelectItem() {
		return this.m_selectFacilityTreeItem;
	}
	/**
	 * @return m_facilityTreeItemを返します。
	 */
	public FacilityTreeItem getFacilityTreeItem() {
		return m_facilityTreeItem;
	}
}