/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * システム通知情報を変更するクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyNotifyRelation {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( ModifyNotifyRelation.class );
	
	/**
	 * システム通知情報を変更します。
	 * <p>
	 * <ol>
	 *  <li>通知IDより、システム通知情報を取得します。</li>
	 *  <li>システム通知情報を変更します。</li>
	 *  <li>システム通知情報に設定されているシステム通知イベント情報を削除します。</li>
	 *  <li>システム通知イベント情報を作成し、通知情報に設定します。</li>
	 * </ol>
	 * 
	 * @param info 変更対象のシステム通知情報
	 * @return 変更に成功した場合、<code> true </code>
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.SystemNotifyInfoBean
	 * @see com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoBean
	 * @see com.clustercontrol.notify.factory.DeleteSystemNotify#deleteEvents(Collection)
	 */
	@SuppressWarnings("unchecked")
	public boolean modify(Collection info, String notifyGroupId) throws CreateException, FinderException, RemoveException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		NotifyRelationInfo relation = null;

// 処理の冒頭で既存の関連テーブルを削除するロジックに変更したため、コメントアウトした uchiyama
//		boolean isDelete=false;
		
		try 
		{
			/**
			 * 通知グループと通知IDは更新のたびに内容が変わる可能性があるので、
			 * findByPKでデータを読み出し更新するのでは、消え残る可能性がある。
			 * そこで、通知グループに紐つくものをすべて削除し、再度投入する。
			 **/
			// システム通知イベント情報を削除
			if(notifyGroupId != null && !notifyGroupId.equals("")){
				DeleteNotifyRelation delete = new DeleteNotifyRelation();
				delete.delete(notifyGroupId);
			}
			
			if(info != null){

//				// システム通知イベント情報を削除
//				DeleteNotifyRelation delete = new DeleteNotifyRelation();
				
			    Iterator<NotifyRelationInfo> it= info.iterator();
			    
			    while(it.hasNext()){
			    	
			    	 relation = it.next();
				
					if(relation != null){

//						if(!isDelete){
//							/**
//							 * 通知グループと通知IDは更新のたびに内容が変わる可能性があるので、
//							 * findByPKでデータを読み出し更新するのでは、消え残る可能性がある。
//							 * そこで、通知グループに紐つくものをすべて削除し、再度投入する。
//							 **/
//							
//						delete.delete(relation.getNotifyGroupId());
//						isDelete = true;
//						
//						}
						
						 NotifyRelationInfoUtil.getLocalHome().create(
								relation.getNotifyGroupId(),
								relation.getNotifyId(),
								relation.getNotifyType(),
								relation.getNotifyFlg()
								);
					}
				}
			}

			
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
		//	String[] args = { info.getNotifyId() };
		//	apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
		//	String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		}
		return true;
	}
	
}
