package org.postgresforest.util;

import net.jcip.annotations.*;

/**
 *  異なる３種のクラスを保持するためだけのユーティリティクラス。
 *  主に関数の戻り値として複数の異なるクラスのオブジェクトを返す時に使用する。
 *  Pair2のアクセッサメソッドに加え、getThird()で3番目の要素を取得できる。
 *  このクラスのインスタンスはImmutableであり、並行アクセスが可能。
 *  （但し各要素についてはそれぞれのスレッドセーフ性に依存する）
 */
@Immutable public final class Pair3<T1, T2, T3> {
    private final T1 first;
    private final T2 second;
    private final T3 third;
    public Pair3(final T1 first, final T2 second, final T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }
    public T1 getFirst() {
        return first;
    }
    public T2 getSecond() {
        return second;
    }
    public T3 getThird() {
        return third;
    }
}
