package org.postgresforest.apibase;

import java.sql.*;
import java.util.concurrent.*;

import org.postgresforest.exception.*;

public final class DatabaseMetaDataTask {
    
    public static final class AllProceduresAreCallable implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public AllProceduresAreCallable(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.allProceduresAreCallable());
        }
    }
    
    public static final class AllTablesAreSelectable implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public AllTablesAreSelectable(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.allTablesAreSelectable());
        }
    }
    
    public static final class DataDefinitionCausesTransactionCommit implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public DataDefinitionCausesTransactionCommit(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.dataDefinitionCausesTransactionCommit());
        }
    }
    
    public static final class DataDefinitionIgnoredInTransactions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public DataDefinitionIgnoredInTransactions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.dataDefinitionIgnoredInTransactions());
        }
    }
    
    public static final class DoesMaxRowSizeIncludeBlobs implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public DoesMaxRowSizeIncludeBlobs(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.doesMaxRowSizeIncludeBlobs());
        }
    }
    
    public static final class GetBestRowIdentifier implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final int arg3;
        private boolean arg4;
        public GetBestRowIdentifier(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, int arg3, boolean arg4) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getBestRowIdentifier(arg0, arg1, arg2, arg3, arg4);
        }
    }
    
    public static final class GetCatalogs implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetCatalogs(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getCatalogs();
        }
    }
    
    public static final class GetCatalogTerm implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetCatalogTerm(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getCatalogTerm();
        }
    }
    
    public static final class GetColumnPrivileges implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        public GetColumnPrivileges(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getColumnPrivileges(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetColumns implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        public GetColumns(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getColumns(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetCrossReference implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        private final String arg4;
        private final String arg5;
        
        public GetCrossReference(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getCrossReference(arg0, arg1, arg2, arg3, arg4, arg5);
        }
    }
    
    public static final class GetDatabaseProductName implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetDatabaseProductName(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDatabaseProductName();
        }
    }
    
    public static final class GetDatabaseProductVersion implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetDatabaseProductVersion(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDatabaseProductVersion();
        }
    }
    
    public static final class GetDefaultTransactionIsolation implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetDefaultTransactionIsolation(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getDefaultTransactionIsolation());
        }
    }
    
    public static final class GetDriverName implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetDriverName(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDriverName();
        }
    }
    
    public static final class GetDriverVersion implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetDriverVersion(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getDriverVersion();
        }
    }
    
    public static final class GetExportedKeys implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetExportedKeys(DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getExportedKeys(arg0, arg1, arg2);
        }
    }
    
    public static final class GetExtraNameCharacters implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetExtraNameCharacters(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getExtraNameCharacters();
        }
    }
    
    public static final class GetIdentifierQuoteString implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetIdentifierQuoteString(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getIdentifierQuoteString();
        }
    }
    
    public static final class GetImportedKeys implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetImportedKeys(DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getImportedKeys(arg0, arg1, arg2);
        }
    }
    
    public static final class GetIndexInfo implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final boolean arg3;
        private final boolean arg4;
        
        public GetIndexInfo(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, boolean arg3, boolean arg4) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getIndexInfo(arg0, arg1, arg2, arg3, arg4);
        }
    }
    
    public static final class GetMaxBinaryLiteralLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxBinaryLiteralLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxBinaryLiteralLength());
        }
    }
    
    public static final class GetMaxCatalogNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxCatalogNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxCatalogNameLength());
        }
    }
    
    public static final class GetMaxCharLiteralLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxCharLiteralLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxCharLiteralLength());
        }
    }
    
    public static final class GetMaxColumnNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnNameLength());
        }
    }
    
    public static final class GetMaxColumnsInGroupBy implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInGroupBy(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInGroupBy());
        }
    }
    
    public static final class GetMaxColumnsInIndex implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInIndex(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInIndex());
        }
    }
    
    public static final class GetMaxColumnsInOrderBy implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInOrderBy(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInOrderBy());
        }
    }
    
    public static final class GetMaxColumnsInSelect implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInSelect(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInSelect());
        }
    }
    
    public static final class GetMaxColumnsInTable implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxColumnsInTable(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxColumnsInTable());
        }
    }
    
    public static final class GetMaxConnections implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxConnections(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxConnections());
        }
    }
    
    public static final class GetMaxCursorNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxCursorNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxCursorNameLength());
        }
    }
    
    public static final class GetMaxIndexLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxIndexLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxIndexLength());
        }
    }
    
    public static final class GetMaxProcedureNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxProcedureNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxProcedureNameLength());
        }
    }
    
    public static final class GetMaxRowSize implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxRowSize(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxRowSize());
        }
    }
    
    public static final class GetMaxSchemaNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxSchemaNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxSchemaNameLength());
        }
    }
    
    public static final class GetMaxStatementLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxStatementLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxStatementLength());
        }
    }
    
    public static final class GetMaxStatements implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxStatements(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxStatements());
        }
    }
    
    public static final class GetMaxTableNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxTableNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxTableNameLength());
        }
    }
    
    public static final class GetMaxTablesInSelect implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxTablesInSelect(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxTablesInSelect());
        }
    }
    
    public static final class GetMaxUserNameLength implements Callable<Integer> {
        private final DatabaseMetaData dbmd;
        public GetMaxUserNameLength(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Integer call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(dbmd.getMaxUserNameLength());
        }
    }
    
    public static final class GetNumericFunctions implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetNumericFunctions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getNumericFunctions();
        }
    }
    
    public static final class GetPrimaryKeys implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetPrimaryKeys(DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getPrimaryKeys(arg0, arg1, arg2);
        }
    }
    
    public static final class GetProcedureColumns implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String arg3;
        
        public GetProcedureColumns(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String arg3) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getProcedureColumns(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetProcedures implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        
        public GetProcedures(DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getProcedures(arg0, arg1, arg2);
        }
    }
    
    public static final class GetProcedureTerm implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetProcedureTerm(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getProcedureTerm();
        }
    }
    
    public static final class GetSchemaTerm implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetSchemaTerm(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSchemaTerm();
        }
    }
    
    public static final class GetSchemas implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetSchemas(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSchemas();
        }
    }
    
    public static final class GetSearchStringEscape implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetSearchStringEscape(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSearchStringEscape();
        }
    }
    
    public static final class GetSQLKeywords implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetSQLKeywords(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSQLKeywords();
        }
    }
    
    public static final class GetStringFunctions implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetStringFunctions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getStringFunctions();
        }
    }
    
    public static final class GetSystemFunctions implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetSystemFunctions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getSystemFunctions();
        }
    }
    
    public static final class GetTablePrivileges implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        public GetTablePrivileges(DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTablePrivileges(arg0, arg1, arg2);
        }
    }
    
    public static final class GetTables implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        private final String[] arg3;
        public GetTables(DatabaseMetaData dbmd, String arg0, String arg1, String arg2, String[] arg3) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = (arg3 != null) ? arg3.clone() : null;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTables(arg0, arg1, arg2, arg3);
        }
    }
    
    public static final class GetTableTypes implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetTableTypes(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTableTypes();
        }
    }
    
    public static final class GetTimeDateFunctions implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetTimeDateFunctions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTimeDateFunctions();
        }
    }
    
    public static final class GetTypeInfo implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        public GetTypeInfo(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getTypeInfo();
        }
    }
    
    public static final class GetUserName implements Callable<String> {
        private final DatabaseMetaData dbmd;
        public GetUserName(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public String call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getUserName();
        }
    }
    
    public static final class GetVersionColumns implements Callable<ResultSet> {
        private final DatabaseMetaData dbmd;
        private final String arg0;
        private final String arg1;
        private final String arg2;
        public GetVersionColumns(DatabaseMetaData dbmd, String arg0, String arg1, String arg2) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public ResultSet call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return dbmd.getVersionColumns(arg0, arg1, arg2);
        }
    }
    
    public static final class IsCatalogAtStart implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public IsCatalogAtStart(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.isCatalogAtStart());
        }
    }
    
    public static final class IsReadOnly implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public IsReadOnly(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.isReadOnly());
        }
    }
    
    public static final class NullPlusNonNullIsNull implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullPlusNonNullIsNull(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullPlusNonNullIsNull());
        }
    }
    
    public static final class NullsAreSortedAtEnd implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedAtEnd(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedAtEnd());
        }
    }
    
    public static final class NullsAreSortedAtStart implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedAtStart(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedAtStart());
        }
    }
    
    public static final class NullsAreSortedHigh implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedHigh(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedHigh());
        }
    }
    
    public static final class NullsAreSortedLow implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public NullsAreSortedLow(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.nullsAreSortedLow());
        }
    }
    
    public static final class StoresLowerCaseIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresLowerCaseIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesLowerCaseIdentifiers());
        }
    }
    
    public static final class StoresLowerCaseQuotedIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresLowerCaseQuotedIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesLowerCaseQuotedIdentifiers());
        }
    }
    
    public static final class StoresMixedCaseIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresMixedCaseIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesMixedCaseIdentifiers());
        }
    }
    
    public static final class StoresMixedCaseQuotedIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresMixedCaseQuotedIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesMixedCaseQuotedIdentifiers());
        }
    }
    
    public static final class StoresUpperCaseIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresUpperCaseIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesUpperCaseIdentifiers());
        }
    }
    
    public static final class StoresUpperCaseQuotedIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public StoresUpperCaseQuotedIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.storesUpperCaseQuotedIdentifiers());
        }
    }
    
    public static final class SupportsAlterTableWithAddColumn implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsAlterTableWithAddColumn(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsAlterTableWithAddColumn());
        }
    }
    
    public static final class SupportsAlterTableWithDropColumn implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsAlterTableWithDropColumn(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsAlterTableWithDropColumn());
        }
    }
    
    public static final class SupportsANSI92EntryLevelSQL implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsANSI92EntryLevelSQL(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsANSI92EntryLevelSQL());
        }
    }
    
    public static final class SupportsANSI92FullSQL implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsANSI92FullSQL(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsANSI92FullSQL());
        }
    }
    
    public static final class SupportsANSI92IntermediateSQL implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsANSI92IntermediateSQL(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsANSI92IntermediateSQL());
        }
    }
    
    public static final class SupportsCatalogsInDataManipulation implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInDataManipulation(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInDataManipulation());
        }
    }
    
    public static final class SupportsCatalogsInIndexDefinitions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInIndexDefinitions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInIndexDefinitions());
        }
    }
    
    public static final class SupportsCatalogsInPrivilegeDefinitions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInPrivilegeDefinitions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInPrivilegeDefinitions());
        }
    }
    
    public static final class SupportsCatalogsInProcedureCalls implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInProcedureCalls(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInProcedureCalls());
        }
    }
    
    public static final class SupportsCatalogsInTableDefinitions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCatalogsInTableDefinitions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCatalogsInTableDefinitions());
        }
    }
    
    public static final class SupportsColumnAliasing implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsColumnAliasing(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsColumnAliasing());
        }
    }
    
    public static final class SupportsConvert implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsConvert(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsConvert());
        }
    }
    
    public static final class SupportsConvert_IntInt implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        private final int arg0;
        private final int arg1;
        public SupportsConvert_IntInt(DatabaseMetaData dbmd, int arg0, int arg1) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsConvert(arg0, arg1));
        }
    }
    
    public static final class SupportsCoreSQLGrammar implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCoreSQLGrammar(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCoreSQLGrammar());
        }
    }
    
    public static final class SupportsCorrelatedSubqueries implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsCorrelatedSubqueries(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsCorrelatedSubqueries());
        }
    }
    
    public static final class SupportsDataDefinitionAndDataManipulationTransactions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsDataDefinitionAndDataManipulationTransactions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsDataDefinitionAndDataManipulationTransactions());
        }
    }
    
    public static final class SupportsDataManipulationTransactionsOnly implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsDataManipulationTransactionsOnly(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsDataManipulationTransactionsOnly());
        }
    }
    
    public static final class SupportsDifferentTableCorrelationNames implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsDifferentTableCorrelationNames(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsDifferentTableCorrelationNames());
        }
    }
    
    public static final class SupportsExpressionsInOrderBy implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsExpressionsInOrderBy(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsExpressionsInOrderBy());
        }
    }
    
    public static final class SupportsExtendedSQLGrammar implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsExtendedSQLGrammar(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsExtendedSQLGrammar());
        }
    }
    
    public static final class SupportsFullOuterJoins implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsFullOuterJoins(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsFullOuterJoins());
        }
    }
    
    public static final class SupportsGroupBy implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsGroupBy(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsGroupBy());
        }
    }
    
    public static final class SupportsGroupByBeyondSelect implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsGroupByBeyondSelect(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsGroupByBeyondSelect());
        }
    }
    
    public static final class SupportsGroupByUnrelated implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsGroupByUnrelated(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsGroupByUnrelated());
        }
    }
    
    public static final class SupportsIntegrityEnhancementFacility implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsIntegrityEnhancementFacility(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsIntegrityEnhancementFacility());
        }
    }
    
    public static final class SupportsLikeEscapeClause implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsLikeEscapeClause(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsLikeEscapeClause());
        }
    }
    
    public static final class SupportsLimitedOuterJoins implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsLimitedOuterJoins(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsLimitedOuterJoins());
        }
    }
    
    public static final class SupportsMinimumSQLGrammar implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMinimumSQLGrammar(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMinimumSQLGrammar());
        }
    }
    
    public static final class SupportsMixedCaseIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMixedCaseIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMixedCaseIdentifiers());
        }
    }
    
    public static final class SupportsMixedCaseQuotedIdentifiers implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMixedCaseQuotedIdentifiers(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMixedCaseQuotedIdentifiers());
        }
    }
    
    public static final class SupportsMultipleResultSets implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMultipleResultSets(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMultipleResultSets());
        }
    }
    
    public static final class SupportsMultipleTransactions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsMultipleTransactions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsMultipleTransactions());
        }
    }
    
    public static final class SupportsNonNullableColumns implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsNonNullableColumns(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsNonNullableColumns());
        }
    }
    
    public static final class SupportsOpenCursorsAcrossCommit implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenCursorsAcrossCommit(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenCursorsAcrossCommit());
        }
    }
    
    public static final class SupportsOpenCursorsAcrossRollback implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenCursorsAcrossRollback(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenCursorsAcrossRollback());
        }
    }
    
    public static final class SupportsOpenStatementsAcrossCommit implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenStatementsAcrossCommit(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenStatementsAcrossCommit());
        }
    }
    
    public static final class SupportsOpenStatementsAcrossRollback implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOpenStatementsAcrossRollback(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOpenStatementsAcrossRollback());
        }
    }
    
    public static final class SupportsOrderByUnrelated implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOrderByUnrelated(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOrderByUnrelated());
        }
    }
    
    public static final class SupportsOuterJoins implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsOuterJoins(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsOuterJoins());
        }
    }
    
    public static final class SupportsPositionedDelete implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsPositionedDelete(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsPositionedDelete());
        }
    }
    
    public static final class SupportsPositionedUpdate implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsPositionedUpdate(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsPositionedUpdate());
        }
    }
    
    public static final class SupportsSchemasInDataManipulation implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInDataManipulation(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInDataManipulation());
        }
    }
    
    public static final class SupportsSchemasInIndexDefinitions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInIndexDefinitions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInIndexDefinitions());
        }
    }
    
    public static final class SupportsSchemasInPrivilegeDefinitions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInPrivilegeDefinitions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInPrivilegeDefinitions());
        }
    }
    
    public static final class SupportsSchemasInProcedureCalls implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInProcedureCalls(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInProcedureCalls());
        }
    }
    
    public static final class SupportsSchemasInTableDefinitions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSchemasInTableDefinitions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSchemasInTableDefinitions());
        }
    }
    
    public static final class SupportsSelectForUpdate implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSelectForUpdate(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSelectForUpdate());
        }
    }
    
    public static final class SupportsStoredProcedures implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsStoredProcedures(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsStoredProcedures());
        }
    }
    
    public static final class SupportsSubqueriesInComparisons implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInComparisons(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInComparisons());
        }
    }
    
    public static final class SupportsSubqueriesInExists implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInExists(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInExists());
        }
    }
    
    public static final class SupportsSubqueriesInIns implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInIns(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInIns());
        }
    }
    
    public static final class SupportsSubqueriesInQuantifieds implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsSubqueriesInQuantifieds(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsSubqueriesInQuantifieds());
        }
    }
    
    public static final class SupportsTableCorrelationNames implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsTableCorrelationNames(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsTableCorrelationNames());
        }
    }
    
    public static final class SupportsTransactionIsolationLevel implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        private final int arg0;
        public SupportsTransactionIsolationLevel(DatabaseMetaData dbmd, int arg0) {
            this.dbmd = dbmd;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsTransactionIsolationLevel(arg0));
        }
    }
    
    public static final class SupportsTransactions implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsTransactions(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsTransactions());
        }
    }
    
    public static final class SupportsUnion implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsUnion(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsUnion());
        }
    }
    
    public static final class SupportsUnionAll implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public SupportsUnionAll(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.supportsUnionAll());
        }
    }
    
    public static final class UsesLocalFilePerTable implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public UsesLocalFilePerTable(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.usesLocalFilePerTable());
        }
    }
    
    public static final class UsesLocalFiles implements Callable<Boolean> {
        private final DatabaseMetaData dbmd;
        public UsesLocalFiles(DatabaseMetaData dbmd) {
            this.dbmd = dbmd;
        }
        public Boolean call() throws Exception {
            if (dbmd == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(dbmd.usesLocalFiles());
        }
    }
}
