/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.net.SocketTimeoutException;
import java.sql.SQLException;
import org.postgresforest.core.ParameterList;
import org.postgresforest.core.Query;
import org.postgresforest.core.QueryExecutor;
import org.postgresforest.core.ResultHandler;
import org.postgresforest.vm.Logger;
import org.postgresforest.vm.core.SimpleResultHandler;
import org.postgresforest.vm.err.DistError;

public class StatementExecuteSub {
    public static final int ERR_NONE = 0;
    public static final int ERR_BROKEN = -1;
    public static final int ERR_NOT_BROKEN = -2;
    public static final int ERR_TIMEOUT = -3;
    public static final int ERR_ROLLBACK = -4;
    protected SimpleResultHandler m_resultHandler;
    protected int m_ErrCode;
    protected SQLException m_errobj;
    protected String m_name;

    public StatementExecuteSub(String logName) {
        this.m_name = logName;
    }

    public void execute(QueryExecutor queryExecutor, Query query, ParameterList parameterList, int maxRows, int fetchSize, int flags) {
        try {
            this.m_ErrCode = 0;
            this.m_errobj = null;
            this.m_resultHandler = new SimpleResultHandler();
            queryExecutor.execute(query, parameterList, (ResultHandler)this.m_resultHandler, maxRows, fetchSize, flags);
            Logger.info(this.m_name + ": Execution of a query was completed. (" + query + ")");
        }
        catch (SQLException e) {
            Logger.info(this.m_name + ": Query execution error = " + "\n" + e.toString());
            if (e.getCause() instanceof SocketTimeoutException) {
                this.m_ErrCode = -3;
                return;
            }
            if (DistError.isRollBack(e)) {
                Logger.info(this.m_name + ": RollBack!!" + "\n" + e.toString());
                this.m_ErrCode = -4;
                this.m_errobj = e;
                return;
            }
            boolean isErr = DistError.isBroken(e);
            this.m_ErrCode = isErr ? -1 : -2;
            this.m_errobj = e;
        }
        Logger.debug(this.m_name + ":execute End");
    }

    public SQLException getErrobj() {
        return this.m_errobj;
    }

    public int getErrCode() {
        return this.m_ErrCode;
    }

    public SimpleResultHandler getResultHandler() {
        return this.m_resultHandler;
    }
}

