/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class TextDrawer
extends ElementDrawer {
    protected JRStyledTextParser styledTextParser = null;
    protected TextRenderer textRenderer = null;

    public TextDrawer(TextRenderer textRenderer, JRStyledTextParser styledTextParser) {
        this.textRenderer = textRenderer;
        this.styledTextParser = styledTextParser;
    }

    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintText text = (JRPrintText)element;
        JRStyledText styledText = this.getStyledText(text, false);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX() + offsetX;
        int y = text.getY() + offsetY;
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = text.getTopPadding();
        int leftPadding = text.getLeftPadding();
        int bottomPadding = text.getBottomPadding();
        int rightPadding = text.getRightPadding();
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + offsetY + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + offsetX + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
            case 3: {
                int tmpPadding = topPadding;
                x = text.getX() + offsetX + text.getWidth();
                y = text.getY() + offsetY + text.getHeight();
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = Math.PI;
                break;
            }
        }
        grx.rotate(angle, x, y);
        if (text.getMode() == 1) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(x, y, width, height);
        }
        if (allText.length() > 0) {
            grx.setColor(text.getForecolor());
            this.textRenderer.render(grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, text.getTextHeight(), text.getHorizontalAlignment(), text.getVerticalAlignment(), text.getLineSpacingFactor(), text.getLeadingOffset(), text.getFontSize(), text.isStyledText(), styledText, allText);
        }
        grx.rotate(-angle, x, y);
        this.drawBox(grx, text, text, offsetX, offsetY);
    }

    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(JRFontUtil.setAttributes(attributes, textElement));
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (setBackcolor && textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }
}

