/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization.impl.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.logging.Logger;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
import org.jboss.remoting.serialization.IMarshalledValue;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.serialization.impl.java.JavaMarshalledValue;

public class JavaSerializationManager
extends SerializationManager {
    protected static final Logger log = Logger.getLogger(JavaSerializationManager.class);

    public ObjectInputStream createInput(InputStream input, ClassLoader loader) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating ObjectInputStreamWithClassLoader");
        }
        return new ObjectInputStreamWithClassLoader(input, loader);
    }

    public ObjectOutputStream createOutput(OutputStream output) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating ObjectOutputStream");
        }
        return new ObjectOutputStream(output);
    }

    public IMarshalledValue createdMarshalledValue(Object source) throws IOException {
        if (source instanceof IMarshalledValue) {
            return (IMarshalledValue)source;
        }
        return new JavaMarshalledValue(source);
    }

    public IMarshalledValue createMarshalledValueForClone(Object original) throws IOException {
        return this.createdMarshalledValue(original);
    }

    public void sendObject(ObjectOutputStream oos, Object dataObject, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                this.sendObjectVersion1_2(oos, dataObject);
                break;
            }
            case 22: {
                this.sendObjectVersion2_2(oos, dataObject);
                break;
            }
            default: {
                throw new IOException("Can not process version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
            }
        }
    }

    protected void sendObjectVersion1_2(ObjectOutputStream oos, Object dataObject) throws IOException {
        oos.writeObject(dataObject);
        oos.reset();
        oos.writeObject(Boolean.TRUE);
        oos.flush();
        oos.reset();
    }

    protected void sendObjectVersion2_2(ObjectOutputStream oos, Object dataObject) throws IOException {
        oos.reset();
        oos.writeObject(dataObject);
        oos.flush();
    }

    public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: {
                return this.receiveObjectVersion1_2(inputStream, customClassLoader);
            }
            case 22: {
                return this.receiveObjectVersion2_2(inputStream, customClassLoader);
            }
        }
        throw new IOException("Can not process version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
    }

    protected Object receiveObjectVersion1_2(InputStream inputStream, ClassLoader customClassLoader) throws IOException, ClassNotFoundException {
        ObjectInputStream objInputStream = null;
        Object obj = null;
        if (inputStream instanceof ObjectInputStreamWithClassLoader) {
            if (((ObjectInputStreamWithClassLoader)inputStream).getClassLoader() == null) {
                ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
            }
            objInputStream = (ObjectInputStream)inputStream;
        } else {
            objInputStream = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : (customClassLoader != null ? SerializationStreamFactory.getManagerInstance("java").createInput(inputStream, customClassLoader) : SerializationStreamFactory.getManagerInstance("java").createRegularInput(inputStream));
        }
        try {
            obj = objInputStream.readObject();
        }
        catch (IOException e) {
            log.debug((Object)"", (Throwable)e);
            throw e;
        }
        try {
            objInputStream.readObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        return obj;
    }

    protected Object receiveObjectVersion2_2(InputStream inputStream, ClassLoader customClassLoader) throws IOException, ClassNotFoundException {
        ObjectInputStream objInputStream = null;
        Object obj = null;
        if (inputStream instanceof ObjectInputStreamWithClassLoader) {
            if (((ObjectInputStreamWithClassLoader)inputStream).getClassLoader() == null) {
                ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
            }
            objInputStream = (ObjectInputStream)inputStream;
        } else {
            objInputStream = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : (customClassLoader != null ? SerializationStreamFactory.getManagerInstance("java").createInput(inputStream, customClassLoader) : SerializationStreamFactory.getManagerInstance("java").createRegularInput(inputStream));
        }
        obj = objInputStream.readObject();
        if (inputStream instanceof ObjectInputStreamWithClassLoader) {
            ((ObjectInputStreamWithClassLoader)inputStream).clearCache();
        }
        return obj;
    }
}

