/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.encryption;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;

public class KeyGeneratorUtil {
    protected static final Logger log = Logger.getLogger(KeyGeneratorUtil.class);

    public void genKeys() throws Exception {
        this.getKey("DES");
        this.getKey("DESede");
        this.getKey("AES");
        this.getKey("RC4");
        this.getKey("Blowfish");
    }

    private Key getKey(String algo) {
        SecretKey key = null;
        try {
            KeyGenerator gen = KeyGenerator.getInstance(algo);
            key = gen.generateKey();
            this.serializeToFile(key, algo);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return key;
    }

    private void serializeToFile(Key key, String algo) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(algo + ".key"));
        out.writeObject(key);
        out.close();
    }

    public static void main(String[] args) {
        KeyGeneratorUtil u = new KeyGeneratorUtil();
        try {
            u.genKeys();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

