/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocationWrapper;
import org.jboss.aop.metadata.SimpleMetaData;

public class MethodInvocation
extends InvocationBase
implements Externalizable {
    static final long serialVersionUID = -1313717554016611763L;
    protected Object[] arguments;
    protected long methodHash;
    protected MarshalledObject marshalledArguments;
    protected Method advisedMethod;
    protected Method unadvisedMethod;

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append("advisedMethod=").append(this.advisedMethod);
        sb.append(", unadvisedMethod=").append(this.unadvisedMethod);
        sb.append(", metadata=").append(this.metadata);
        sb.append(", targetObject=").append(this.targetObject);
        sb.append(", arguments=").append(this.arguments);
        sb.append("]");
        return sb.toString();
    }

    public MethodInvocation(MethodInfo info, Interceptor[] interceptors) {
        this(interceptors, info.getHash(), info.getAdvisedMethod(), info.getUnadvisedMethod(), info.getAdvisor());
    }

    public MethodInvocation(Interceptor[] interceptors, long methodHash, Method advisedMethod, Method unadvisedMethod, Advisor advisor) {
        super(interceptors);
        this.advisor = advisor;
        this.methodHash = methodHash;
        this.advisedMethod = advisedMethod;
        this.unadvisedMethod = unadvisedMethod;
    }

    protected MethodInvocation(Interceptor[] interceptors) {
        super(interceptors);
    }

    public MethodInvocation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        if (this.interceptors != null && this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        try {
            return this.getActualMethod().invoke(this.getTargetObject(), this.arguments);
        }
        catch (Throwable t) {
            throw MethodInvocation.handleErrors(this.getTargetObject(), this.getMethod(), this.arguments, t);
        }
    }

    public static Throwable handleErrors(Object target, Method method, Object[] arguments, Throwable t) throws Throwable {
        if (t instanceof IllegalArgumentException) {
            Class<?> targetClass;
            if (target == null) {
                throw new IllegalArgumentException("Null target for method " + method);
            }
            Class<?> methodClass = method.getClass();
            if (!methodClass.isAssignableFrom(targetClass = target.getClass())) {
                throw new IllegalArgumentException("Wrong target. " + targetClass + " for " + method);
            }
            ArrayList<String> expected = new ArrayList<String>();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                expected.add(parameterTypes[i].getName());
            }
            ArrayList<String> actual = new ArrayList<String>();
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    if (arguments[i] == null) {
                        actual.add(null);
                        continue;
                    }
                    actual.add(arguments[i].getClass().getName());
                }
            }
            throw new IllegalArgumentException("Wrong arguments. " + method.getName() + " expected=" + expected + " actual=" + actual);
        }
        if (t instanceof InvocationTargetException) {
            throw ((InvocationTargetException)t).getTargetException();
        }
        throw t;
    }

    public Object resolveAnnotation(Class annotation) {
        Object val = super.resolveAnnotation(annotation);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveAnnotation(this.getMethod(), annotation)) != null) {
            return val;
        }
        return null;
    }

    public Object resolveAnnotation(Class[] annotations) {
        Object val = super.resolveAnnotation(annotations);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveAnnotation(this.getMethod(), annotations)) != null) {
            return val;
        }
        return null;
    }

    public Object getMetaData(Object group, Object attr) {
        Object val = super.getMetaData(group, attr);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getMethodMetaData().resolve((Invocation)this, group, attr)) != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getDefaultMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        return null;
    }

    public Invocation getWrapper(Interceptor[] newchain) {
        MethodInvocationWrapper wrapper = new MethodInvocationWrapper(this, newchain);
        return wrapper;
    }

    public Invocation copy() {
        MethodInvocation wrapper = new MethodInvocation(this.interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
        wrapper.metadata = this.metadata;
        wrapper.currentInterceptor = this.currentInterceptor;
        wrapper.instanceResolver = this.instanceResolver;
        wrapper.setTargetObject(this.getTargetObject());
        wrapper.setArguments(this.getArguments());
        return wrapper;
    }

    public Object[] getArguments() {
        if (this.arguments == null && this.marshalledArguments != null) {
            try {
                this.arguments = (Object[])this.marshalledArguments.get();
                this.marshalledArguments = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.advisedMethod;
    }

    public Method getActualMethod() {
        return this.unadvisedMethod;
    }

    public long getMethodHash() {
        return this.methodHash;
    }

    public Advisor getAdvisor() {
        return this.advisor;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.methodHash);
        if (this.getArguments() == null) {
            out.writeObject(null);
        } else {
            MarshalledObject<Object[]> mo = new MarshalledObject<Object[]>(this.getArguments());
            out.writeObject(mo);
        }
        out.writeObject(this.metadata);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.methodHash = in.readLong();
        this.marshalledArguments = (MarshalledObject)in.readObject();
        this.metadata = (SimpleMetaData)in.readObject();
    }
}

