package org.postgresforest;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

import org.postgresforest.apibase.*;

public class ForestCallableStatement extends ForestPreparedStatement implements
        CallableStatement {
    
    public ForestCallableStatement(EntrypointCommonResource epCommonResource,
            List<CallableStatement> stmts, String executeSql) {
        super(epCommonResource, stmts, executeSql);
    }
    
    public Array getArray(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Array getArray(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        checkObjectClosed();
        final Callable<BigDecimal> task = new CallableStatementTask.GetBigDecimal(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0, arg1);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public Blob getBlob(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Blob getBlob(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean getBoolean(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Boolean> task = new CallableStatementTask.GetBoolean(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).booleanValue();
    }
    
    public boolean getBoolean(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public byte getByte(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Byte> task = new CallableStatementTask.GetByte(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).byteValue();
    }
    
    public byte getByte(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public byte[] getBytes(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<byte[]> task = new CallableStatementTask.GetBytes(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public byte[] getBytes(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Clob getClob(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Clob getClob(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Date getDate(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Date> task = new CallableStatementTask.GetDate(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public Date getDate(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public double getDouble(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Double> task = new CallableStatementTask.GetDouble(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).doubleValue();
    }
    
    public double getDouble(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public float getFloat(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Float> task = new CallableStatementTask.GetFloat(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).floatValue();
    }
    
    public float getFloat(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getInt(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Integer> task = new CallableStatementTask.GetInt(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).intValue();
    }
    
    public int getInt(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public long getLong(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Long> task = new CallableStatementTask.GetLong(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).longValue();
    }
    
    public long getLong(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Object> task = new CallableStatementTask.GetObject(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public Object getObject(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(int arg0, Map<String, Class<?>> arg1)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Object getObject(String arg0, Map<String, Class<?>> arg1)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Ref getRef(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Ref getRef(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public short getShort(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Short> task = new CallableStatementTask.GetShort(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId()).shortValue();
    }
    
    public short getShort(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public String getString(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<String> task = new CallableStatementTask.GetString(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public String getString(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Time getTime(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Time> task = new CallableStatementTask.GetTime(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public Time getTime(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(int arg0) throws SQLException {
        checkObjectClosed();
        final Callable<Timestamp> task = new CallableStatementTask.GetTimestamp(
                (CallableStatement) stmts.get(getFixExecuteId()), arg0);
        return epCommonResource.executeOneApi(task, getFixExecuteId());
    }
    
    public Timestamp getTimestamp(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public Timestamp getTimestamp(String arg0, Calendar arg1)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public URL getURL(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public URL getURL(String arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(int arg0, int arg1) throws SQLException {
        checkObjectClosed();
        final Callable<Void> task0 = new CallableStatementTask.RegisterOutParameter_IntInt((CallableStatement) stmts.get(0), arg0, arg1);
        final Callable<Void> task1 = new CallableStatementTask.RegisterOutParameter_IntInt((CallableStatement) stmts.get(1), arg0, arg1);
        epCommonResource.executeAllApi(task0, task1);
        return;
    }
    
    public void registerOutParameter(String arg0, int arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(int arg0, int arg1, int arg2)
            throws SQLException {
        checkObjectClosed();
        final Callable<Void> task0 = new CallableStatementTask.RegisterOutParameter_IntIntInt((CallableStatement) stmts.get(0), arg0, arg1, arg2);
        final Callable<Void> task1 = new CallableStatementTask.RegisterOutParameter_IntIntInt((CallableStatement) stmts.get(1), arg0, arg1, arg2);
        epCommonResource.executeAllApi(task0, task1);
        return;
    }
    
    public void registerOutParameter(int arg0, int arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(String arg0, int arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void registerOutParameter(String arg0, int arg1, String arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setAsciiStream(String arg0, InputStream arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBinaryStream(String arg0, InputStream arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBoolean(String arg0, boolean arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setByte(String arg0, byte arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setBytes(String arg0, byte[] arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setCharacterStream(String arg0, Reader arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setDate(String arg0, Date arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setDate(String arg0, Date arg1, Calendar arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setDouble(String arg0, double arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setFloat(String arg0, float arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setInt(String arg0, int arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setLong(String arg0, long arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setNull(String arg0, int arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setNull(String arg0, int arg1, String arg2) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(String arg0, Object arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(String arg0, Object arg1, int arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setObject(String arg0, Object arg1, int arg2, int arg3)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setShort(String arg0, short arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setString(String arg0, String arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTime(String arg0, Time arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTime(String arg0, Time arg1, Calendar arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void setURL(String arg0, URL arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public boolean wasNull() throws SQLException {
        checkObjectClosed();
        final Callable<Boolean> task = new CallableStatementTask.WasNull(
                (CallableStatement) stmts.get(getFixExecuteId()));
        return epCommonResource.executeOneApi(task, getFixExecuteId()).booleanValue();
    }
    
}
