/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.repository.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 値の型定義情報を管理するEntity Bean <BR>
 * @ejb.bean name="CollectorPlatformMst"
 *           jndi-name="CollectorPlatformMst"
 *           type="CMP"
 *           schema="CollectorPlatformMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="platformId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only
 *     read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_platform_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorPlatformMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 *   
 */
public abstract class CollectorPlatformMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String platformId,
			String platformName
			) throws javax.ejb.CreateException {
		
		this.setPlatformId(platformId);
		this.setPlatformName(platformName);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param platformId プラットフォーム種別
	 * @param platformName プラットフォーム名称
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String platformId,
			String platformName
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * プラットフォーム種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォーム種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * プラットフォーム名称を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the platformName.
	 */
	public abstract String getPlatformName();

	/**
	 * プラットフォーム名称を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param platformName The platformName to set.
	 */
	public abstract void setPlatformName(String platformName);

}
