/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.bean;

import java.util.ArrayList;

/**
 * プロセス監視に必要なOIDを定義するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpSharedTableConstant {
	
    public final static String SHARED_TABLE_JNDI_NAME = "SharedTable";
    public final static String POLLER_MANAGER_JNDI_NAME = "SnmpPollerManager";
    
    public static final String OID_RUN_NAME  = ".1.3.6.1.2.1.25.4.2.1.2";
    public static final String OID_RUN_PATH  = ".1.3.6.1.2.1.25.4.2.1.4";
    public static final String OID_RUN_PARAM = ".1.3.6.1.2.1.25.4.2.1.5";
    
    public static final ArrayList<String> PROCESS_OIDS = new ArrayList<String>();
 
    static {
    	PROCESS_OIDS.add(OID_RUN_NAME);
    	PROCESS_OIDS.add(OID_RUN_PATH);
    	PROCESS_OIDS.add(OID_RUN_PARAM);
    }
}
