/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知ステータス情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyStatusInfo"
 *     jndi-name="NotifyStatusInfo"
 *     type="CMP"
 *     primkey-field="notifyId","priority"
 *     schema="NotifyStatusInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_status_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyStatusInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyStatusInfoPK"
 */
public abstract class NotifyStatusInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知ステータス情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param statusFlg ステータス通知フラグ
	 * @param statusInhibitionFlg ステータス抑制フラグ
	 * @param statusVaildPeriod ステータス有効期間 
	 * @param statusInvaildFlg ステータス有効期間外フラグ
	 * @param statusUpdatePriority ステータス更新時重要度
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyStatusInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer statusFlg,
			Integer statusInhibitionFlg,
			Integer statusVaildPeriod,
			Integer statusInvaildFlg,
			Integer statusUpdatePriority
			) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
	    setStatusFlg(statusFlg);
	    setStatusInhibitionFlg(statusInhibitionFlg);
		setStatusValidPeriod(statusVaildPeriod);
		setStatusInvalidFlg(statusInvaildFlg);
		setStatusUpdatePriority(statusUpdatePriority);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * ステータス通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getStatusFlg();
	
	/**
	 * ステータス通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusFlg ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setStatusFlg(Integer statusFlg);
	
	
	/**
	 * ステータスの抑制制御の処理フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 存続期間経過後の処理フラグ
	 * 
	 */
	public abstract Integer getStatusInhibitionFlg();
	
	/**
	 *  ステータスの抑制制御の処理フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusInvalidFlg 存続期間経過後の処理フラグ
	 * 
	 */
	public abstract void setStatusInhibitionFlg(Integer statusInhibitionFlg);
	
	/**
	 * ステータス情報の存続期間を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_valid_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public abstract Integer getStatusValidPeriod();
	
	/**
	 * ステータス情報の存続期間を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusValidPeriod ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public abstract void setStatusValidPeriod(Integer statusValidPeriod);
	
	/**
	 * 存続期間経過後の処理フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_invalid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public abstract Integer getStatusInvalidFlg();
	
	/**
	 * 存続期間経過後の処理フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusInvalidFlg 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public abstract void setStatusInvalidFlg(Integer statusInvalidFlg);
	
	/**
	 * ステータス情報更新時重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_update_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getStatusUpdatePriority();
	
	/**
	 * ステータス情報更新時重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusUpdatePriority ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setStatusUpdatePriority(Integer statusUpdatePriority);

	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyStatusInfo"
	 * role-name="NotifyStatusInfo-NotifyInfo(multi)"
	 * cascade-delete="yes"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
