/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyInfo"
 *     jndi-name="NotifyInfo"
 *     type="CMP"
 *     primkey-field="notifyId"
 *     schema="NotifyInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 * 
 * @ejb.finder
 *   signature="java.util.Collection findByUseType(java.lang.String keyWord)"
 *   query="SELECT OBJECT(a) FROM NotifyInfo as a WHERE a.notifyId like ?1"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM NotifyInfo as a ORDER BY a.notifyId"
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="java.lang.String"
 */
public abstract class NotifyInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param description 説明
	 * @param notifyType 通知タイプ
	 * @param inhibitionFlg 抑制間隔フラグ
	 * @param inhibitionFrequency 抑制回数
	 * @param inhibitionPeriod 抑制期間（分）
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 作成ユーザ
	 * @param updateUser 更新ユーザ
	 * @param vaildFlg 有効フラグ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public java.lang.String ejbCreate(
			String notifyId,
			String description,
			Integer notifyType,
			Integer inhibitionFlg,
			Integer inhibitionFrequency,
			Integer inhibitionPeriod,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser,
			String updateUser,
			Integer vaildFlg
//			String useType	FIXME	 * @param useType 使用種別
			) throws javax.ejb.CreateException {
		
		
		setNotifyId(notifyId);
		setDescription(description);
		setNotifyType(notifyType);
		setInhibitionFlg(inhibitionFlg);
		setInhibitionFrequency(inhibitionFrequency);
		setInhibitionPeriod(inhibitionPeriod);
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
		setValidFlg(vaildFlg);
//		setUseType(useType);
		
		return null;
	}
	


	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();
	
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);
	
    /**
     * 通知タイプを返します。
     *
     * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method 
     * 
     * @return notifyType 通知タイプ
     *
     * @see com.clustercontrol.bean.ValidConstant
     */
	public abstract Integer getNotifyType();
	
	
	/**
	 * 通知タイプを設定します。
	 *
	 * @ejb.interface-method
	 * 
	 * @param notifyType
	 */
	public abstract void setNotifyType(Integer notifyType);
	
	
	/**
	 * 抑制間隔フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public abstract Integer getInhibitionFlg();
	
	/**
	 * 抑制間隔フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFlg 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public abstract void setInhibitionFlg(Integer inhibitionFlg);
	
	/**
	 * 抑制回数を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_frequency"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 抑制回数
	 */
	public abstract Integer getInhibitionFrequency();
	
	/**
	 * 抑制回数を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFrequency 抑制回数
	 */
	public abstract void setInhibitionFrequency(Integer inhibitionFrequency);
	
	/**
	 * 抑制期間を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return inhibitionPeriod 抑制期間（分）
	 */
	public abstract Integer getInhibitionPeriod();
	
	/**
	 * 抑制期間を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param inhibitionPeriod 抑制期間（分）
	 */
	public abstract void setInhibitionPeriod(Integer inhibitionPeriod);
	
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public abstract Timestamp getRegDate();
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	
	/**
	 *更新ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return updateUser 更新ユーザ
	 */
	public abstract String getUpdateUser();
	
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method 
	 * @param updateUser 更新ユーザ
	 */
	public abstract void setUpdateUser(String updateUser);
	
	
     /**
	 *作成ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return updateUser 作成ユーザ
	 */
	public abstract String getRegUser();

	/**
	 * 作成ユーザを設定します。
	 * 
	 * @ejb.interface-method 
	 * @param regUser 作成ユーザ
	 */
	public abstract void setRegUser(String regUser);

	
	/**
	 * 有効無効フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return vaildFlg 有効無効フラグ
	 */
	public abstract Integer getValidFlg();

	/**
     * 有効無効フラグを設定します。
     * 
     * @ejb.interface-method 
	 * @param vaildFlg 有効無効フラグ
	 */
	public abstract void setValidFlg(Integer validFlg);

// FIXME
//	/**
//	 * 使用種別を返します。
//	 * 
//	 * @ejb.persistent-field 
//	 * @ejb.persistence
//	 *    column-name="use_type"
//	 *     jdbc-type="VARCHAR"
//	 *     sql-type="VARCHAR(64)"
//	 *     read-only="false"
//	 *  
//	 * @ejb.interface-method
//	 * 
//	 * @return useType 使用種別
//	 */
//	public abstract String getUseType();
//
//	/**
//     * 使用種別を設定します。
//     * 
//     * @ejb.interface-method 
//	 * @param useType 使用種別
//	 */
//	public abstract void setUseType(String useType);
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知イベント情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyEventInfo"
	 * role-name="NotifyInfo-NotifyEventInfo(single)"
	 * 
	 * @return 通知イベント情報のコレクション
	 */
	public abstract Collection<NotifyEventInfo> getNotifyEventInfo();
	
	/**
	 * 通知イベント情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知イベント情報のコレクション
	 */
	public abstract void setNotifyEventInfo(Collection<NotifyEventInfo> collection);
	
	/**
	 * 通知ステータス情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyStatusInfo"
	 * role-name="NotifyInfo-NotifyStatusInfo(single)"
	 * 
	 * return 通知ジョブ情報のコレクション
	 * 
	 * */
	public abstract Collection<NotifyStatusInfo> getNotifyStatusInfo();
	
	/**
	 * 通知ステータス情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知ステータス情報のコレクション
	 */
	public abstract void setNotifyStatusInfo(Collection<NotifyStatusInfo> collection);
	
	
	/**
	 * 通知メール情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 *  
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyMailInfo"
	 * role-name="NotifyInfo-NotifyMailInfo(single)"
	 * 
	 * */
	public abstract Collection<NotifyMailInfo> getNotifyMailInfo();
	
	/**
	 * 通知メール情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知メール情報のコレクション
	 */
	public abstract void setNotifyMailInfo(Collection<NotifyMailInfo> collection);
	
	/**
	 * 通知ジョブ情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyJobInfo"
	 * role-name="NotifyInfo-NotifyJobInfo(single)"
	 * 
	 * retrun 通知ジョブ情報のコレクション
	 * */
	public abstract Collection<NotifyJobInfo> getNotifyJobInfo();
	
	/**
	 * 通知ジョブ情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知ジョブ情報のコレクション
	 */
	public abstract void setNotifyJobInfo(Collection<NotifyJobInfo> collection);
	
	
	/**
	 * 通知ログエスカレーション情報を返します。
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation
	 * name="NotifyInfo-NotifyLogEscalateInfo"
	 * role-name="NotifyInfo-NotifyLogEscalateInfo(single)"
	 * 
	 * retrun 通知ログエスカレーション情報のコレクション
	 * */
	public abstract Collection<NotifyLogEscalateInfo> getNotifyLogEscalateInfo();
	
	/**
	 * 通知ログエスカレーション情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知ログエスカレーション情報のコレクション
	 */
	public abstract void setNotifyLogEscalateInfo(Collection<NotifyLogEscalateInfo> collection);
	
	
}
