/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 
 * メンテナンス種別に関する情報を保持するEntity Beanです。
 * 
 * @ejb.bean name="MaintenanceTypeMst"
 *           display-name="MaintenanceTypeMst"
 *           description="MaintenanceTypeMst"
 *           jndi-name="MaintenanceTypeMst"
 *           type="CMP"
 *           primkey-field="type_id"
 *           cmp-version="2.x"
 *           schema="MaintenanceTypeMst"
 *           data-source="java:/HinemosDS"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.read-only
 *    read-only="true"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 * @ejb.persistence 
 *   table-name="maintenance_type_mst" 
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MaintenanceTypeMst as a ORDER BY a.order_no"  
 *    signature="java.util.Collection findAll()"
 *      
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MaintenanceTypeMst as a ORDER BY a.order_no"  
 *    signature="java.util.Collection findAllNameId()"
 *      
 *
 * @ejb.pk class="java.lang.String"
 * 
 */
public abstract class MaintenanceTypeMstBean implements EntityBean {
	
	public MaintenanceTypeMstBean() {
		super();
		// TODO 自動生成されたコンストラクター・スタブ
	}

	public void setEntityContext(EntityContext ctx)
		throws EJBException,
		RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}
	
	
	/**
	 * 
	 * @ejb.create-method
	 * 
	 * @param type_id
	 * @param name_id
	 * @param order_no
	 * @return
	 * @throws CreateException
	 */
	public String ejbCreate(
			String type_id,
			String name_id,
			int order_no
			) throws CreateException {
		
		this.setType_id(type_id);
		this.setName_id(name_id);
		this.setOrder_no(order_no);
				
		return null;
	}
	
	public void ejbPostCreate() throws CreateException {}	

	public void ejbRemove()
		throws RemoveException,
		EJBException,
		RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbActivate() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbLoad() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbStore() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	/**
	 * 
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="type_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR(64)"
     *     read-only="false"
     *     
	 * @ejb.pk-field 
     *     
     * @ejb.interface-method
     * 
	 * @return
	 */
	public abstract String getType_id();

	/**
     * @ejb.interface-method
     * 
	 * @param type_id
	 */
	public abstract void setType_id(String type_id);
	

	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="name_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 
	 */
	public abstract String getName_id();

	/**
     * @ejb.interface-method
     * 
	 * @param name_id
	 */
	public abstract void setName_id(String name_id);
	
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract int getOrder_no();
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @param order_no
	 */
	public abstract void setOrder_no(int order_no);
	
}
