/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.Time;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl;

/**
 * ジョブ待ち条件時刻情報のBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobStartTimeInfo"
 *           jndi-name="JobStartTimeInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl
 */
public abstract class JobStartTimeInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
	protected String session_id;
	/** ジョブID */
	protected String job_id;
	/** 時刻 */
    protected Time start_time;
    
    /**
     * ジョブ待ち条件時刻情報を生成します。
     * 
     * @ejb.create-method 
     * 
     * @param session_id セッションID
     * @param job_id ジョブID
     * @param start_time 時刻
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     */
    public JobStartTimeInfoPK ejbCreate(
            String session_id, 
            String job_id, 
            Time start_time
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.start_time = start_time;
        return null;
    }

	/**
	 * 全てのジョブ待ち条件時刻情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ待ち条件時刻情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl#findByPrimaryKey(JobStartTimeInfoPK)
	 */
	public JobStartTimeInfoPK ejbFindByPrimaryKey(JobStartTimeInfoPK pk) throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
    public java.lang.String getSession_id() {
    	return session_id;
    }

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
	/**
	 * 時刻を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 時刻
	 */
    public java.sql.Time getStart_time() {
    	return start_time;
    }

    /**
     * 時刻を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param start_time 時刻
     */
    public void setStart_time(java.sql.Time start_time) {
    	this.start_time = start_time;
    }
    
	/**
	 * ジョブ待ち条件情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean#ejbFindByPrimaryKey(JobStartInfoPK)
	 */
    public JobStartInfoLocal getJobStartInfo() {
    	JobStartInfoLocal jobStartInfo = null;
		try {
			jobStartInfo = JobStartInfoUtil.getLocalHome().findByPrimaryKey(new JobStartInfoPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartInfo;
	}
    
	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブ待ち条件時刻情報をジョブ待ち条件時刻マスタから作成します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl#makeSession(String, Collection)
	 */
    public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException{
    	JobStartTimeInfoDAOImpl jstiDAO = new JobStartTimeInfoDAOImpl(); 
    	
    	jstiDAO.makeSession(sessionId, jobs);
    }
    
    
}
