/*
/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[一覧]ビューの「キャンセル」を行うクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CancelJobAction implements IViewActionDelegate {
	/** ビュー */
    protected IViewPart m_view;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /**
     * ジョブ[一覧]ビューの「キャンセル」が押された場合に、ジョブ[一覧]ビューを更新します。
     * <p>
	 * <ol>
	 * <li>確認ダイアログを表示します。</li>
	 * <li>ジョブ[一覧]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.view.JobListView#update()
     */
    public void run(IAction action) {
        if (m_view instanceof JobListView) {
            JobListView view = (JobListView)m_view.getAdapter(JobListView.class);
            
            // 確認ダイアログを生成
            String message;
            if(view.isUpdate()){
            	message = Messages.getString("message.job.43") + "\n" + 
                        Messages.getString("message.job.30");
            }
            else{
            	message = Messages.getString("message.job.30");
            }
            if (MessageDialog.openQuestion(
        			null, 
        			Messages.getString("confirmed"), 
        			message)) {
                view.update();
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}