/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerHome;
import com.clustercontrol.util.LoginManager;


/**
 * EJBとのコネクションを管理するクラスです。<BR>
 * シングルトン
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class EjbConnectionManager {
	/** シングルトン用インスタンス */
	private static EjbConnectionManager m_instance = null;
	/** コンテキスト */
	private NamingContext m_ctx = null;
	
	/**
	 * 本クラスのインスタンスを返す。<BR>
	 * シングルトン用インスタンスがnullならば、インスタンスを生成する。<BR>
	 * シングルトン用インスタンスが存在すれば、シングルトン用インスタンスを返す。
	 * @return インスタンス
	 */
	public static EjbConnectionManager getConnectionManager() {
		if (m_instance == null) {
			m_instance = new EjbConnectionManager();
		}
		return m_instance;
	}
	
	private EjbConnectionManager() {
	}
	
	/**
	 * ジョブ管理SessionBeanのインスタンスを返す。
	 * 
	 * ログインマネージャにてコンテキストを取得し、
	 * ジョブ管理SessionBeanのインスタンスを取得する
	 * 
	 * @return ジョブ管理SessionBean
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerHome
	 * @see com.clustercontrol.util.LoginManager
	 */
	public synchronized JobController getJobController() {
		try {
			m_ctx = LoginManager.getContextManager().getNamingContext();
		} catch (NamingException e) {
			return null;
		}
		
		JobControllerHome home;
		try {
			home = (JobControllerHome)m_ctx.lookup(JobControllerHome.JNDI_NAME);
			return home.create();
		} catch (NamingException e) {
		} catch (RemoteException e) {
		} catch (CreateException e) {
		}
		m_ctx = null;
		return null;
	}
}
