/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.ejb.session;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.factory.RunMonitorHttp;
import com.clustercontrol.http.factory.RunMonitorHttpString;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.factory.RunMonitor;

/**
 * Quartzから呼び出されてエージェント監視を行うSession Bean<BR>
 * 
 * @ejb.bean name="MonitorHttpRunManagement"
 *           jndi-name="MonitorHttpRunManagement"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 *           
 * @ejb.permission
 *     unchecked="true"
 */
public abstract class MonitorHttpRunManagementBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorHttpRunManagementBean.class );
	
	/**
     * Quartzからのコールバックメソッド<BR>
     * 
     * @ejb.interface-method
     * 
     * @param monitorTypeId 監視監視対象ID
     * @param monitorId 監視項目ID
     * @param monitorType 監視判定タイプ
     * @throws CreateException
     * @throws FinderException
     * @throws RemoveException
     * @throws JMSException
     * @throws NamingException
     * @throws NotSupportedException
     * @throws HeuristicMixedException
     * @throws HeuristicRollbackException
     * @throws RollbackException
     * @throws InvalidTransactionException
     * @throws SystemException
     * @version 2.1.0
     * @since 2.1.0
     */
    public void run(String monitorTypeId, String monitorId, Integer monitorType) throws CreateException, FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, SystemException {
    	
        m_log.debug("run()");
        
        RunMonitor monitor = null;
		if(monitorType.intValue() == MonitorTypeConstant.TYPE_NUMERIC){
			// 数値監視の場合
			monitor = new RunMonitorHttp();
		}
		else if(monitorType.intValue() == MonitorTypeConstant.TYPE_STRING){
			// 文字列監視の場合
			monitor = new RunMonitorHttpString();
		}
		
		if(monitor != null){
			monitor.run(monitorTypeId, monitorId);
		}
    }
}
