/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;

/**
 * マスタ更新クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyMaster {
    protected static Log m_log = LogFactory.getLog( ModifyMaster.class );

	/**
	 * 一括制御マスタ情報更新
	 * 
	 * @param info
	 * @param parentInfo
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException 
	 */
	public void update(ItemInfo info, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException {
		
		if(info == null || parentInfo == null){
			return;
		}
		
		//cast出来ない場合はreturnする
		if (!(info instanceof TypeInfo) 
				&& !(info instanceof CommandInfo)
				&& !(info instanceof CommandParameterInfo)
				&& !(info instanceof ParameterInfo)
				&& !(info instanceof ParameterSelectInfo)
				&& !(parentInfo instanceof CommandInfo)
				&& !(parentInfo instanceof TypeInfo))
			return;
		
		if(info.getType() == ItemConstant.TYPE_TYPE){
			updateType((TypeInfo)info);
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			updateCommand((CommandInfo)info, 
					((TypeInfo)parentInfo).getId());
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			updateCommandParameter((CommandParameterInfo)info, 
					((CommandInfo)parentInfo).getId());
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			updateParameter((ParameterInfo)info);
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			updateParameterSelect((ParameterSelectInfo)info);
		}
	}
	
	/**
	 * 種別情報更新
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateType(TypeInfo info) throws NamingException, CreateException {
		boolean create = false;
		CRunTypeMstLocal type = null;
		
		try {
			//IDで種別を検索し取得
			type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(info.getId());
		} catch (FinderException e) {
			//見つからない場合、作成フラグをtrueにする
			create = true;
		}
		
		if(create){
			//CRunTypeMstLocalを作成
			CRunTypeMstUtil.getLocalHome().create(
					info.getId(), 
					info.getName(), 
					Integer.valueOf(info.getOrderNo()));
		}
		else{
			//CRunTypeMstLocalを更新
			type.setName_id(info.getName());
			type.setOrder_no(Integer.valueOf(info.getOrderNo()));
			type = null;
		}
	}
	
	/**
	 * コマンド情報更新
	 * 
	 * @param info
	 * @param typeId
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateCommand(CommandInfo info, String typeId) throws NamingException, CreateException {
		boolean create = false;
		CRunCmdMstLocal command = null;
		
		try {
			//IDでコマンドを検索し取得
			command = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(info.getId());
		} catch (FinderException e) {
			//見つからない場合、作成フラグをtrueにする
			create = true;
		}
		
		//コマンド作成・更新
		if(create){
			//CRunCmdMstLocalを作成
			CRunCmdMstUtil.getLocalHome().create(
					info.getId(), 
					typeId, 
					Integer.valueOf(info.getOrderNo()), 
					info.getName(), 
					Integer.valueOf(info.getCommandType()), 
					info.getCommand());
		}
		else{
			//CRunCmdMstLocalを更新
			command.setName_id(info.getName());
			command.setOrder_no(Integer.valueOf(info.getOrderNo()));
			command.setCommand(info.getCommand());
			command.setCommand_type(Integer.valueOf(info.getCommandType()));
			command = null;
		}
		
		//終了状態作成・更新
		if(info.getEndStatus() != null && 
				info.getEndStatus() instanceof ArrayList){
			//CRunEndMstLocalを作成
			for(int i = 0; i < info.getEndStatus().size(); i++){
				EndStatusInfo endStatus = info.getEndStatus().get(i);
				if(endStatus instanceof EndStatusInfo){
					
					boolean endCreate = false;
					CRunEndMstLocal end = null;
					
					try {
						//IDで終了状態を検索し取得
						end = CRunEndMstUtil.getLocalHome().findByPrimaryKey(
								new CRunEndMstPK(
										info.getId(), 
										Integer.valueOf(endStatus.getEndStatus())));
					} catch (FinderException e) {
						//見つからない場合、作成フラグをtrueにする
						endCreate = true;
					}
				
					//終了状態作成・更新
					if(endCreate){
						//CRunEndMstLocalを作成
						CRunEndMstUtil.getLocalHome().create(
								info.getId(), 
								Integer.valueOf(endStatus.getEndStatus()), 
								Integer.valueOf(endStatus.getStartRangeValue()),
								Integer.valueOf(endStatus.getEndRangeValue()));
					}
					else{
						//CRunEndMstLocalを更新
						end.setEnd_value_from(Integer.valueOf(endStatus.getStartRangeValue()));
						end.setEnd_value_to(Integer.valueOf(endStatus.getEndRangeValue()));
						end = null;
					}
				}
			}
		}
	}
	
	/**
	 * コマンドパラメータ情報更新
	 * 
	 * @param info
	 * @param commandId
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateCommandParameter(CommandParameterInfo info, String commandId) throws NamingException, CreateException {
		boolean create = false;
		CRunCmdParamMstLocal commandParameter = null;
		
		try {
			//IDでコマンドパラメータを検索し取得
			commandParameter = CRunCmdParamMstUtil.getLocalHome().findByPrimaryKey(
					new CRunCmdParamMstPK(commandId, info.getId()));
		} catch (FinderException e) {
			//見つからない場合、作成フラグをtrueにする
			create = true;
		}
		
		//コマンドパラメータ作成・更新
		if(create){
			//CRunCmdParamMstLocalを作成
			CRunCmdParamMstUtil.getLocalHome().create(
					commandId, 
					info.getId(), 
					Integer.valueOf(info.getOrderNo()), 
					info.getPrefix());
		}
		else{
			//CRunCmdParamMstLocalを更新
			commandParameter.setParam_prefix(info.getPrefix());
			commandParameter.setOrder_no(Integer.valueOf(info.getOrderNo()));
			commandParameter = null;
		}
	}
	
	/**
	 * パラメータ情報更新
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateParameter(ParameterInfo info) throws NamingException, CreateException {
		boolean create = false;
		CRunParamMstLocal parameter = null;
		
		try {
			//IDでパラメータを検索し取得
			parameter = CRunParamMstUtil.getLocalHome().findByPrimaryKey(info.getId());
		} catch (FinderException e) {
			//見つからない場合、作成フラグをtrueにする
			create = true;
		}
		
		//パラメータ作成・更新
		if(create){
			//CRunParamMstLocalを作成
			CRunParamMstUtil.getLocalHome().create(
					info.getId(), 
					info.getName(), 
					Integer.valueOf(info.getParamType()));
		}
		else{
			//CRunParamMstLocalを更新
			parameter.setName_id(info.getName());
			parameter.setParam_type(Integer.valueOf(info.getParamType()));
			parameter = null;
		}
	}
	
	
	/**
	 * パラメータ選択肢情報更新
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException
	 */
	public void updateParameterSelect(ParameterSelectInfo info) throws NamingException, CreateException, RemoveException {
		boolean create = false;
		CRunParamSelectMstLocal select = null;
		
		try {
			//IDでパラメータ選択肢を検索し取得
			select = CRunParamSelectMstUtil.getLocalHome().findByPrimaryKey(
					new CRunParamSelectMstPK(info.getId(), Integer.valueOf(info.getOrderNo())));
		} catch (FinderException e) {
			//見つからない場合、作成フラグをtrueにする
			create = true;
		}
		
		//パラメータ選択肢作成・更新
		if(create){
			//CRunParamSelectMstLocalを作成
			CRunParamSelectMstUtil.getLocalHome().create(
					info.getId(), 
					Integer.valueOf(info.getOrderNo()), 
					info.getName(), 
					info.getValue());
		}
		else{
			//CRunParamSelectMstLocalを更新
			select.setName_id(info.getName());
			select.setParam_value(info.getValue());
			select = null;
		}
	}
	
	/**
	 * 一括制御マスタ情報表示順序更新
	 * 
	 * @param info1
	 * @param info2
	 * @param parentInfo
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException
	 * @throws FinderException
	 */
	public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException, FinderException {
    	int orderNo1 = info1.getOrderNo();
    	int orderNo2 = info2.getOrderNo();
    	
    	if(info1.getType() == ItemConstant.TYPE_SELECT_ITEM){
    		//パラメータ選択肢
    		
    		DeleteMaster delete = new DeleteMaster();
    		
            //選択したアイテムを削除
        	delete.delete(info1, parentInfo);
            	
        	//移動ターゲットアイテムを削除
        	delete.delete(info2, parentInfo);
            
            //選択したアイテムを移動ターゲットアイテムの順序で作成
            info1.setOrderNo(orderNo2);
            update(info1, parentInfo);
            
        	//移動ターゲットアイテムを選択アイテムの順序で作成
            info2.setOrderNo(orderNo1);
            update(info2, parentInfo);
    	}
    	else{
    		//パラメータ選択肢以外

            //選択したアイテムを移動ターゲットアイテムの順序で更新
            info1.setOrderNo(orderNo2);
            update(info1, parentInfo);
            	
        	//移動ターゲットアイテムを選択アイテムの順序で更新
            info2.setOrderNo(orderNo1);
            update(info2, parentInfo);
    	}
	}
}
