/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.etc.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.notify.mail.dialog.MailTemplateListDialog;

/**
 * メールテンプレート[一覧]ダイアログを表示するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class MailTemplateListAction implements IWorkbenchWindowActionDelegate {

	/**
     * 終了する際に呼ばれます。
     * 
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() {
    }

    /**
     * ワークベンチにロードされた際に呼ばれます。
     * 
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
    public void init(IWorkbenchWindow window) {
    }

    /**
     * メールテンプレート[一覧]ダイアログを表示します。
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.notify.mail.dialog.MailTemplateListDialog
     */
    public void run(IAction action) {
        // シェルを取得
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                .getShell();

        // ダイアログ表示及び終了処理
        MailTemplateListDialog dialog = new MailTemplateListDialog(shell);
        dialog.open();
    }

    /**
     * 選択を変更した際に呼ばれます。
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}