/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite;

import java.util.ArrayList;
import java.util.Date;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.calendar.action.GetCalendarList;
import com.clustercontrol.calendar.action.GetCalendarListTableDefine;
import com.clustercontrol.calendar.bean.CalendarListTableDefine;
import com.clustercontrol.calendar.composite.action.CalendarSelectionChangedListener;
import com.clustercontrol.calendar.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;

/**
 * カレンダ一覧コンポジットクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarListComposite extends Composite {
    protected CalendarTableViewer m_viewer = null;
    
    protected Table m_table = null;
    protected Label m_labelCount = null;
    
    protected String m_calendarId = null;
    protected Date m_base = null;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     * @since 2.0.0
     */
    public CalendarListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 初期化処理<BR>
     * 
     * @since 2.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        
		//カレンダ一覧テーブル作成
        m_table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
        m_table.setHeaderVisible(true);
        m_table.setLinesVisible(true);
        
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        m_table.setLayoutData(gridData);
        
        m_labelCount = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelCount.setLayoutData(gridData);

        m_viewer = new CalendarTableViewer(m_table);
        m_viewer.createTableColumn(GetCalendarListTableDefine.get(),
        		CalendarListTableDefine.SORT_COLUMN_INDEX,
        		CalendarListTableDefine.SORT_ORDER);

        m_viewer.addSelectionChangedListener(new CalendarSelectionChangedListener(this));
        
        m_viewer.getTable().getVerticalBar().addSelectionListener(
        		new VerticalBarSelectionListener(this));
    }

    /**
     * 更新処理<BR>
     * 
     * @since 2.0.0
     */
    public void update() {
        ArrayList info = null;

        //カレンダ一覧情報取得
        GetCalendarList getCalendarList = new GetCalendarList();
        info = getCalendarList.getAll();
		if(info == null){
			info = new ArrayList();
		}
		
        m_viewer.setInput(info);

        Object[] args = { new Integer(info.size()) };
        m_labelCount.setText(Messages.getString("records", args));
    }

    /**
     * このコンポジットが利用するテーブルビューアを取得します。<BR>
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを取得します。<BR>
     * 
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }
    
	/**
	 * @return
	 */
	public String getCalendarId() {
		return m_calendarId;
	}
	
	/**
	 * @param calendarId
	 */
	public void setCalendarId(String calendarId) {
		m_calendarId = calendarId;
	}
}