/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.accesscontrol.bean.UserListTableDefine;
import com.clustercontrol.accesscontrol.composite.UserListComposite;
import com.clustercontrol.accesscontrol.dialog.UserDetailDialog;

/**
 * アクセス[ユーザ]ビュー用のテーブルビューア用のDoubleClickListenerクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserDoubleClickListener implements IDoubleClickListener {
	/** アクセス[ユーザ]ビュー用のコンポジット */
    protected UserListComposite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite アクセス[ユーザ]ビュー用のコンポジット
     */
    public UserDoubleClickListener(UserListComposite composite) {
        m_composite = composite;
    }
    
    /**
     * ダブルクリック時に呼び出されます。<BR>
     * アクセス[ユーザ]ビューのテーブルビューアをダブルクリックした際に、選択した行の内容をダイアログで表示します。
     * <P>
     * <ol>
	 * <li>イベントから選択行を取得し、選択行からユーザIDを取得します。</li>
	 * <li>ユーザIDからユーザ情報を取得し、ダイアログで表示します。</li>
	 * </ol>
	 * 
     * @param event イベント
     * 
     * @see com.clustercontrol.accesscontrol.dialog.UserDetailDialog
	 * @see org.eclipse.jface.viewers.IDoubleClickListener#doubleClick(org.eclipse.jface.viewers.DoubleClickEvent)
	 */
	public void doubleClick(DoubleClickEvent event) {
		String uid = null;
		
        //UIDを取得
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            uid = (String) info.get(UserListTableDefine.UID);
        }
        
        if(uid != null){
            // ダイアログを生成
            UserDetailDialog dialog = new UserDetailDialog(m_composite.getShell(), uid);

            // ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
            dialog.open();
        }
	}

}
