/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class EllipseDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintEllipse ellipse = (JRPrintEllipse)element;
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getForecolor());
        byte pen = ellipse.getPen();
        Stroke stroke = EllipseDrawer.getStroke(pen);
        if (stroke != null) {
            double cornerOffset = EllipseDrawer.getBorderCornerOffset(pen);
            int sizeAdjust = EllipseDrawer.getRectangleSizeAdjust(pen);
            AffineTransform transform = grx.getTransform();
            grx.translate((double)(ellipse.getX() + offsetX) + cornerOffset, (double)(ellipse.getY() + offsetY) + cornerOffset);
            if (pen == 5) {
                grx.scale(((double)ellipse.getWidth() - 0.5) / (double)ellipse.getWidth(), ((double)ellipse.getHeight() - 0.5) / (double)ellipse.getHeight());
            }
            grx.setStroke(stroke);
            grx.drawOval(0, 0, ellipse.getWidth() - sizeAdjust, ellipse.getHeight() - sizeAdjust);
            grx.setTransform(transform);
        }
    }
}

