/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.postgresforest.jdbc3.AbstractJdbc3Connection;
import org.postgresforest.vm.core.QueryExecutorImpl;
import org.postgresforest.vm.gsc.GscMetaData;
import org.postgresforest.vm.jdbc.ForestDatabaseMetaData;
import org.postgresforest.vm.jdbc.ForestPreparedStatement;
import org.postgresforest.vm.jdbc.ForestStatement;

public class ForestConnection
extends AbstractJdbc3Connection
implements Connection {
    protected QueryExecutorImpl m_queryExecuter = (QueryExecutorImpl)this.getQueryExecutor();

    public ForestConnection(String host, int port, String user, String database, Properties info, String url) throws SQLException {
        super(host, port, user, database, info, url);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new ForestDatabaseMetaData(this);
        }
        return this.metadata;
    }

    public GscMetaData getGscMetaData() {
        return new GscMetaData(this.m_queryExecuter.getGsc());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ForestStatement s = new ForestStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        s.setPrepareThreshold(this.getPrepareThreshold());
        return s;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ForestPreparedStatement s = new ForestPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        s.setPrepareThreshold(this.getPrepareThreshold());
        return s;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.setTypeMapImpl(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        this.m_queryExecuter.waitFree();
        this.m_queryExecuter.setTransactionState(1);
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            super.commit();
        }
        finally {
            this.m_queryExecuter.waitFree();
            this.setUpdateSyncMode(orgSync);
        }
        this.m_queryExecuter.setTransactionState(0);
    }

    public void setMetaDataAccess() {
        this.m_queryExecuter.addMetaDataAccess();
    }

    public void clearMetaDataAccess() {
        this.m_queryExecuter.removeMetaDataAccess();
    }

    public void setAutoCommit(boolean autoCommit, boolean syncronize) throws SQLException {
        this.setUpdateSyncMode(syncronize);
        this.setAutoCommit(autoCommit);
    }

    public boolean getUpdateSyncMode() {
        return this.m_queryExecuter.isUpdateSyncMode();
    }

    public void setUpdateSyncMode(boolean b) {
        this.m_queryExecuter.setUpdateSyncMode(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() throws SQLException {
        try {
            this.setMetaDataAccess();
            int n = super.getTransactionIsolation();
            return n;
        }
        finally {
            this.clearMetaDataAccess();
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.m_queryExecuter.setAutocommit(autoCommit);
        super.setAutoCommit(autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        this.m_queryExecuter.waitFree();
        this.m_queryExecuter.setTransactionState(1);
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            super.rollback();
        }
        finally {
            this.m_queryExecuter.waitFree();
            this.setUpdateSyncMode(orgSync);
        }
        this.m_queryExecuter.setTransactionState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int level) throws SQLException {
        this.m_queryExecuter.waitFree();
        this.m_queryExecuter.setTransactionState(0);
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            super.setTransactionIsolation(level);
        }
        finally {
            this.m_queryExecuter.waitFree();
            this.setUpdateSyncMode(orgSync);
        }
    }
}

