/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.messagecounter;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class MessageStatistics
implements Serializable {
    static final long serialVersionUID = 8056884098781414022L;
    private boolean topic;
    private boolean durable;
    private String name;
    private String subscriptionID;
    private int count;
    private int countDelta;
    private int depth;
    private int depthDelta;
    private long timeLastUpdate;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCountDelta() {
        return this.countDelta;
    }

    public void setCountDelta(int countDelta) {
        this.countDelta = countDelta;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public void setDepthDelta(int depthDelta) {
        this.depthDelta = depthDelta;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public void setSubscriptionID(String subscriptionID) {
        this.subscriptionID = subscriptionID;
    }

    public long getTimeLastUpdate() {
        return this.timeLastUpdate;
    }

    public void setTimeLastUpdate(long timeLastUpdate) {
        this.timeLastUpdate = timeLastUpdate;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public String getAsString() {
        StringBuffer buffer = new StringBuffer(50);
        if (this.topic) {
            buffer.append("Topic,");
        } else {
            buffer.append("Queue,");
        }
        buffer.append(this.name).append(',');
        if (this.subscriptionID != null) {
            buffer.append(this.subscriptionID).append(',');
        } else {
            buffer.append("-,");
        }
        if (this.topic) {
            if (this.durable) {
                buffer.append("DURABLE,");
            } else {
                buffer.append("NONDURABLE,");
            }
        } else {
            buffer.append("-,");
        }
        buffer.append(this.count).append(',').append(this.countDelta).append(',').append(this.depth).append(',').append(this.depthDelta).append(',');
        if (this.timeLastUpdate > 0L) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            buffer.append(dateFormat.format(new Date(this.timeLastUpdate)));
        } else {
            buffer.append('-');
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getAsString();
    }
}

