/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import org.jboss.logging.Logger;

public class PortUtil {
    private static final Logger log = Logger.getLogger(PortUtil.class);
    private static final int MIN_UNPRIVILEGED_PORT = 1024;
    private static final int MAX_LEGAL_PORT = 65535;
    private static int portCounter = 0;
    private static int retryMax = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPort(int p, String host) {
        boolean available = true;
        ServerSocket socket = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            socket = new ServerSocket(p, 0, inetAddress);
        }
        catch (IOException e) {
            log.debug((Object)("port " + p + " already in use.  Will try another."));
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return available;
    }

    public static int findFreePort(String host) throws IOException {
        int tryCount;
        Integer port = null;
        for (tryCount = 0; port == null && tryCount < retryMax; ++tryCount) {
            port = PortUtil.getFreePort(host);
            if (port == null || PortUtil.checkPort(port, host)) continue;
            port = null;
        }
        if (tryCount >= retryMax) {
            throw new IOException("Can not find a free port for use.");
        }
        return port;
    }

    private static Integer getFreePort(String host) {
        int p = PortUtil.getNextPort();
        if (PortUtil.checkPort(p, host)) {
            return new Integer(p);
        }
        return null;
    }

    private static synchronized int getNextPort() {
        if (portCounter < 65535) {
            return portCounter++;
        }
        portCounter = 1024;
        return 65535;
    }

    public static int getRandomStartingPort() {
        int range = 64512;
        int port = new Random(System.currentTimeMillis()).nextInt(range) + 1024;
        return port;
    }

    public static void main(String[] args) {
        try {
            System.out.println("port - " + PortUtil.findFreePort("localhost"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        portCounter = PortUtil.getRandomStartingPort();
    }
}

