/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.client.delegate.ClientBrowserDelegate;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.jms.wireformat.SessionCreateBrowserDelegateResponse;

public class SessionCreateBrowserDelegateRequest
extends RequestSupport {
    private JBossDestination dest;
    private String selector;

    public SessionCreateBrowserDelegateRequest() {
    }

    public SessionCreateBrowserDelegateRequest(String objectId, byte version, JBossDestination destination, String selector) {
        super(objectId, 302, version);
        this.dest = destination;
        this.selector = selector;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.dest = JBossDestination.readDestination(is);
        this.selector = this.readNullableString(is);
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new SessionCreateBrowserDelegateResponse((ClientBrowserDelegate)endpoint.createBrowserDelegate(this.dest, this.selector));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        JBossDestination.writeDestination(os, this.dest);
        this.writeNullableString(this.selector, os);
        os.flush();
    }
}

