/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.clustered.client;

import org.jboss.remoting.samples.transporter.basic.Address;
import org.jboss.remoting.samples.transporter.basic.Customer;
import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
import org.jboss.remoting.samples.transporter.clustered.server.SocketServer;
import org.jboss.remoting.transporter.TransporterClient;

public class Client {
    private String locatorURI = SocketServer.locatorURI;
    private CustomerProcessor customerProcessor = null;

    public void makeClientCall() throws Exception {
        Customer customer = this.createCustomer();
        System.out.println("Customer to be processed: " + customer);
        Customer processedCustomer = this.customerProcessor.processCustomer(customer);
        System.out.println("Customer is now: " + processedCustomer);
    }

    public void getCustomerProcessor() throws Exception {
        this.customerProcessor = (CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, CustomerProcessor.class, true);
    }

    private Customer createCustomer() {
        Customer cust = new Customer();
        cust.setFirstName("Bob");
        cust.setLastName("Smith");
        Address addr = new Address();
        addr.setStreet("101 Oak Stree");
        addr.setCity("Atlanta");
        addr.setZip(30249);
        cust.setAddr(addr);
        return cust;
    }

    public static void main(String[] args) {
        Client client = new Client();
        try {
            client.getCustomerProcessor();
            while (true) {
                try {
                    while (true) {
                        client.makeClientCall();
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

