/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import org.jboss.aop.instrument.OptimizedInvocations;

public abstract class OptimizedBehaviourInvocations
extends OptimizedInvocations {
    protected static void addSetArguments(ClassPool pool, CtClass invocation, CtClass[] params) throws NotFoundException, CannotCompileException {
        if (params == null || params.length == 0) {
            return;
        }
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("setArguments");
        String code = "public void setArguments(java.lang.Object[] args){ ";
        code = code + "   arguments = args; ";
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isPrimitive()) {
                CtPrimitiveType primitive = (CtPrimitiveType)params[i];
                code = code + "   arg" + i + " = ((" + primitive.getWrapperName() + ")args[" + i + "])." + primitive.getGetMethodName() + "(); ";
                continue;
            }
            code = code + "   Object warg" + i + " = args[" + i + "]; ";
            code = code + "   arg" + i + " = (" + params[i].getName() + ")warg" + i + "; ";
        }
        code = code + "}";
        CtMethod setArguments = CtNewMethod.make((String)code, (CtClass)invocation);
        setArguments.setModifiers(template.getModifiers());
        invocation.addMethod(setArguments);
    }

    public static void addGetArguments(ClassPool pool, CtClass invocation, CtClass[] params) throws CannotCompileException {
        OptimizedBehaviourInvocations.addGetArguments(pool, invocation, params, false);
    }

    public static void addGetArguments(ClassPool pool, CtClass invocation, CtClass[] params, boolean hasMarshalledArguments) throws CannotCompileException {
        if (params == null || params.length == 0) {
            return;
        }
        try {
            CtClass superInvocation = invocation.getSuperclass();
            CtMethod template = superInvocation.getDeclaredMethod("getArguments");
            StringBuffer code = new StringBuffer();
            code.append("public Object[] getArguments()");
            code.append("{ ");
            if (hasMarshalledArguments) {
                code.append("   if (super.marshalledArguments != null)");
                code.append("   {");
                code.append("      Object[] args = super.getArguments();");
                code.append("      setArguments(args);");
                code.append("      return args;");
                code.append("   }");
            }
            code.append("   if (arguments != (Object[])null) { return (Object[])arguments; } ");
            code.append("   arguments = new Object[" + params.length + "]; ");
            for (int i = 0; i < params.length; ++i) {
                code.append("   arguments[" + i + "] = ($w)arg" + i + "; ");
            }
            code.append("   return arguments; }");
            CtMethod getArguments = CtNewMethod.make((String)code.toString(), (CtClass)invocation);
            getArguments.setModifiers(template.getModifiers());
            invocation.addMethod(getArguments);
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }

    protected static String setArguments(int length) {
        return OptimizedBehaviourInvocations.setArguments("invocation", length, 0);
    }

    protected static String setArguments(String inv, int length, int offset) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            sb.append(inv + ".arg" + i + " = $" + (i + 1 + offset) + "; ");
        }
        return sb.toString();
    }

    public static void addArgumentFieldsToInvocation(CtClass invocation, CtClass[] params) throws CannotCompileException {
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
    }
}

