/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MultiplexingOutputStream
extends OutputStream {
    protected static final Logger log = Logger.getLogger(MultiplexingOutputStream.class);
    private MultiplexingManager manager;
    private OutputMultiplexor outputMultiplexor;
    private VirtualSocket virtualSocket;
    private SocketId socketId;
    private boolean outputShutdown = false;
    private boolean closed = false;
    private IOException writeException;
    private static final int OPEN = 0;
    private static final int CONNECTION_RESET = 1;
    private static final int CLOSED = 2;
    private int connectionState = 0;
    private byte[] oneByte = new byte[1];
    private byte[] fourBytes = new byte[4];

    public MultiplexingOutputStream(MultiplexingManager manager, SocketId socketId) {
        this(manager, null, socketId);
    }

    public MultiplexingOutputStream(MultiplexingManager manager, VirtualSocket virtualSocket, SocketId socketId) {
        this.manager = manager;
        this.virtualSocket = virtualSocket;
        this.socketId = socketId;
        this.outputMultiplexor = manager.getOutputMultiplexor();
    }

    public void close() throws IOException {
        log.debug((Object)"MultiplexingOutputStream.close() entered");
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.virtualSocket != null) {
            this.virtualSocket.close();
        }
    }

    public void flush() throws IOException {
    }

    public void write(int i) throws IOException {
        this.checkStatus();
        this.oneByte[0] = (byte)i;
        this.outputMultiplexor.write(this.manager, this.socketId, this.oneByte);
    }

    public void write(byte[] array) throws IOException, NullPointerException {
        this.checkStatus();
        this.outputMultiplexor.write(this.manager, this.socketId, array);
    }

    public void write(byte[] array, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        this.checkStatus();
        if (array == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > array.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] subArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            subArray[i] = array[off + i];
        }
        this.outputMultiplexor.write(this.manager, this.socketId, subArray);
    }

    protected void setWriteException(IOException e) {
        this.writeException = e;
    }

    public void writeInt(int i) throws IOException {
        this.fourBytes[0] = (byte)(i >>> 24 & 0xFF);
        this.fourBytes[1] = (byte)(i >>> 16 & 0xFF);
        this.fourBytes[2] = (byte)(i >>> 8 & 0xFF);
        this.fourBytes[3] = (byte)(i >>> 0 & 0xFF);
        this.outputMultiplexor.write(this.manager, this.socketId, this.fourBytes);
    }

    protected void checkStatus() throws IOException {
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.outputShutdown) {
            throw new SocketException("Broken pipe");
        }
        if (this.writeException != null) {
            throw this.writeException;
        }
        switch (this.connectionState) {
            case 0: {
                return;
            }
            case 1: {
                this.connectionState = 2;
                return;
            }
            case 2: {
                throw new SocketException("Broken pipe");
            }
        }
        log.error((Object)("unrecognized connection state: " + this.connectionState));
    }

    protected void handleRemoteDisconnect() {
        log.debug((Object)"entering handleRemoteDisconnect()");
        switch (this.connectionState) {
            case 0: {
                this.connectionState = 1;
                return;
            }
        }
        this.connectionState = 2;
        log.error((Object)("invalid connection state in handleRemoteDisconnect(): " + this.connectionState));
    }

    protected void shutdown() {
        this.outputShutdown = true;
    }

    protected void write(int i, int brackets) throws IOException {
        log.debug((Object)("brackets: " + brackets));
        this.oneByte[0] = (byte)i;
        this.outputMultiplexor.write(this.manager, this.socketId, this.oneByte, brackets);
    }

    protected void writeInt(int i, int brackets) throws IOException {
        log.debug((Object)("brackets: " + brackets));
        this.fourBytes[0] = (byte)(i >>> 24 & 0xFF);
        this.fourBytes[1] = (byte)(i >>> 16 & 0xFF);
        this.fourBytes[2] = (byte)(i >>> 8 & 0xFF);
        this.fourBytes[3] = (byte)(i >>> 0 & 0xFF);
        this.outputMultiplexor.write(this.manager, this.socketId, this.fourBytes, brackets);
    }
}

