/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.search.backend.AddWork;
import org.hibernate.search.backend.DeleteWork;
import org.hibernate.search.backend.UpdateWork;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.LuceneWorker;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchLuceneWorkQueue
implements WorkQueue {
    private Workspace workspace;
    private LuceneWorker worker;
    private List<Work> queue = new ArrayList<Work>();

    public BatchLuceneWorkQueue(Map<Class, DocumentBuilder<Object>> documentBuilders, Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders) {
        this.workspace = new Workspace(documentBuilders, lockableDirectoryProviders);
        this.worker = new LuceneWorker(this.workspace);
    }

    @Override
    public void add(Work work) {
        if (work instanceof UpdateWork) {
            this.queue.add(new DeleteWork(work.getId(), work.getEntity()));
            this.queue.add(new AddWork(work.getId(), work.getEntity(), work.getDocument()));
        } else {
            this.queue.add(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performWork() {
        try {
            for (Work work : this.queue) {
                if (!(work instanceof DeleteWork)) continue;
                this.worker.performWork(work);
            }
            this.workspace.clean();
            for (Work work : this.queue) {
                if (!(work instanceof AddWork)) continue;
                this.worker.performWork(work);
            }
        }
        finally {
            this.workspace.clean();
            this.queue.clear();
        }
    }

    @Override
    public void cancelWork() {
        this.queue.clear();
    }
}

