/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.deploy.shared.factories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.jboss.logging.Logger;

public final class DeploymentFactoryManager {
    private static final Logger log = Logger.getLogger(DeploymentFactoryManager.class);
    private static final DeploymentFactoryManager instance = new DeploymentFactoryManager();
    private Set deploymentFactories = Collections.synchronizedSet(new HashSet());

    private DeploymentFactoryManager() {
    }

    public static DeploymentFactoryManager getInstance() {
        return instance;
    }

    public DeploymentFactory[] getDeploymentFactories() {
        DeploymentFactory[] arr = new DeploymentFactory[this.deploymentFactories.size()];
        return this.deploymentFactories.toArray(arr);
    }

    public DeploymentManager getDeploymentManager(String uri, String userName, String password) throws DeploymentManagerCreationException {
        for (DeploymentFactory factory : this.deploymentFactories) {
            if (!factory.handlesURI(uri)) continue;
            return factory.getDeploymentManager(uri, userName, password);
        }
        throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
    }

    public void registerDeploymentFactory(DeploymentFactory factory) {
        this.deploymentFactories.add(factory);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        for (DeploymentFactory factory : this.deploymentFactories) {
            if (!factory.handlesURI(uri)) continue;
            return factory.getDisconnectedDeploymentManager(uri);
        }
        throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> factoryClass = cl.loadClass("org.jboss.deployment.spi.factories.DeploymentFactoryImpl");
            DeploymentFactory factory = (DeploymentFactory)factoryClass.newInstance();
            DeploymentFactoryManager dfManager = DeploymentFactoryManager.getInstance();
            dfManager.registerDeploymentFactory(factory);
        }
        catch (Exception e) {
            log.error("Cannot register DeploymentFactory: " + e.toString());
        }
    }
}

