/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao.cache;

import com.clustercontrol.repository.dao.FacilityDAOImpl;
import com.clustercontrol.repository.ejb.entity.FacilityBean;
import com.clustercontrol.repository.ejb.entity.FacilityPK;
import com.clustercontrol.repository.util.RepositoryCacheProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedFacilityDAOImpl
extends FacilityDAOImpl {
    private static Log m_log = LogFactory.getLog(CachedFacilityDAOImpl.class);
    private Boolean m_isInit = false;
    private static HashMap<String, Collection> m_ipAddressCache = null;
    private static HashMap<String, Collection> m_nodeNameCache = null;
    private static List<HashMap> m_cacheMapList = new ArrayList<HashMap>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Boolean bl = this.m_isInit;
        synchronized (bl) {
            if (this.m_isInit.booleanValue()) {
                return;
            }
            if (RepositoryCacheProperties.getProperties("common.repository.cache.facility.ipaddress") > 0) {
                m_ipAddressCache = new HashMap();
                m_cacheMapList.add(m_ipAddressCache);
                m_log.info((Object)"FacilityDAO ipAddressCache : enable");
            }
            if (RepositoryCacheProperties.getProperties("common.repository.cache.facility.nodename") > 0) {
                m_nodeNameCache = new HashMap();
                m_cacheMapList.add(m_nodeNameCache);
                m_log.info((Object)"FacilityDAO nodeNameCache : enable");
            }
            this.m_isInit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCacheAll() {
        List<HashMap> list = m_cacheMapList;
        synchronized (list) {
            Iterator<HashMap> itr = m_cacheMapList.iterator();
            while (itr.hasNext()) {
                HashMap map;
                HashMap hashMap = map = itr.next();
                synchronized (hashMap) {
                    m_log.debug((Object)("clearCache() clear : " + map.size()));
                    map.clear();
                }
            }
        }
    }

    public void store(FacilityBean ejb) throws EJBException {
        m_log.debug((Object)"store()");
        super.store(ejb);
        CachedFacilityDAOImpl.clearCacheAll();
    }

    public void remove(FacilityPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)"remove()");
        super.remove(pk);
        CachedFacilityDAOImpl.clearCacheAll();
    }

    public FacilityPK create(FacilityBean ejb) throws CreateException, EJBException {
        m_log.debug((Object)"create()");
        FacilityPK pk = super.create(ejb);
        CachedFacilityDAOImpl.clearCacheAll();
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByIpAddress(String ipAddress) throws FinderException {
        if (m_ipAddressCache == null) {
            return super.findByIpAddress(ipAddress);
        }
        HashMap<String, Collection> hashMap = m_ipAddressCache;
        synchronized (hashMap) {
            if (m_ipAddressCache.containsKey(ipAddress)) {
                return m_ipAddressCache.get(ipAddress);
            }
        }
        Collection ret = super.findByIpAddress(ipAddress);
        HashMap<String, Collection> hashMap2 = m_ipAddressCache;
        synchronized (hashMap2) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("findByIpAddress(String ipAddress) put : " + ipAddress + "  size : " + m_ipAddressCache.size()));
            }
            m_ipAddressCache.put(ipAddress, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByNodeName(String nodeName) throws FinderException {
        if (m_nodeNameCache == null) {
            return super.findByNodeName(nodeName);
        }
        HashMap<String, Collection> hashMap = m_nodeNameCache;
        synchronized (hashMap) {
            if (m_nodeNameCache.containsKey(nodeName)) {
                return m_nodeNameCache.get(nodeName);
            }
        }
        Collection ret = super.findByNodeName(nodeName);
        HashMap<String, Collection> hashMap2 = m_nodeNameCache;
        synchronized (hashMap2) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("findByNodeName(String nodeName) put : " + nodeName + "  size : " + m_nodeNameCache.size()));
            }
            m_nodeNameCache.put(nodeName, ret);
        }
        return ret;
    }
}

