/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.accesscontrol.util.TimeKeeper;
import com.clustercontrol.accesscontrol.util.TimeKeeperService;
import com.clustercontrol.repository.dao.FacilityTreeDAO;
import com.clustercontrol.repository.ejb.entity.FacilityTreeBean;
import com.clustercontrol.repository.ejb.entity.FacilityTreePK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacilityTreeDAOImpl
implements FacilityTreeDAO {
    protected static Log m_log = LogFactory.getLog(FacilityTreeDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    public static final String BASE_DN = "ou=facilitytree";
    protected static final String OBJECT_CLASS_FACILITY_TREE = "ccFacilityTree";
    private static int MAX_RETRY = 3;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load(FacilityTreePK pk, FacilityTreeBean ejb) throws EJBException {
        m_log.trace((Object)("load() : start " + pk.getDn()));
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block18: {
                timer = null;
                this.clearBean(ejb);
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                ejb.setDn(pk.getDn());
                ejb.setFacilityId((String)attrs.get("ccFacilityId").get(0));
                ejb.setTreeType(new Integer((String)attrs.get("ccTreeType").get(0)));
                ejb.setBuiltIn(new Boolean((String)attrs.get("ccFacilityBuiltIn").get(0)));
                ejb.setSortValue(new Integer((String)attrs.get("ccFacilitySortValue").get(0)));
                ejb.setValid(new Boolean((String)attrs.get("ccValid").get(0)));
                m_log.debug((Object)("load() : Dn " + pk.getDn() + " FacilityId " + ejb.getFacilityId() + " TreeType " + ejb.getTreeType()));
                Object var8_9 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block18;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                }
                {
                    break block18;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("load(): catch NamingException" + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var8_9 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"load() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var8_9 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            m_log.trace((Object)("load() : end " + pk.getDn()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void store(FacilityTreeBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block19: {
                timer = null;
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(ejb.getDn());
                BasicAttributes addAttrs = new BasicAttributes();
                BasicAttributes replaceAttrs = new BasicAttributes();
                BasicAttributes removeAttrs = new BasicAttributes();
                if (attrs.get("ccValid") == null && ejb.getValid() != null) {
                    addAttrs.put("ccValid", this.booleanToString(ejb.getValid()));
                } else if (attrs.get("ccValid") != null && ejb.getValid() == null) {
                    removeAttrs.put("ccValid", null);
                } else if (attrs.get("ccValid") != null && ejb.getValid() != null) {
                    replaceAttrs.put("ccValid", this.booleanToString(ejb.getValid()));
                }
                ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
                ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
                ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
                Object var10_7 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block19;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                }
                {
                    break block19;
                    catch (NamingException e) {
                        if (e instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("store(): catch NamingException" + e.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var10_7 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_7 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void remove(FacilityTreePK pk) throws RemoveException, EJBException {
        m_log.trace((Object)("remove() : start " + pk.getDn()));
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block18: {
                timer = null;
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                ctx.destroySubcontext(pk.getDn());
                Object var9_8 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block18;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("remove() context close failed : " + e2.getMessage()));
                }
                {
                    break block18;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("remove(): catch NamingException" + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            AplLogger apllog = new AplLogger("REP", "rep");
                            Object[] args = new String[]{pk.getDn()};
                            apllog.put("SYS", "008", args);
                            throw new EJBException((Exception)ex);
                        }
                        var9_8 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("remove() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"remove() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var9_8 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("remove() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("remove() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            m_log.trace((Object)("remove() : end " + pk.getDn()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FacilityTreePK create(FacilityTreeBean ejb) throws CreateException, EJBException {
        m_log.trace((Object)("createe() : start " + ejb.getDn()));
        FacilityTreePK pk = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block20: {
                timer = null;
                String baseDn = BASE_DN;
                if (ejb.getParentFacilityId() != null && ejb.getParentFacilityId().compareTo("") != 0) {
                    try {
                        FacilityTreePK parentPk = this.findScopeByFacilityId(ejb.getParentFacilityId());
                        baseDn = parentPk.getDn();
                    }
                    catch (FinderException e) {
                        m_log.warn((Object)("create() : " + e.getMessage()));
                        throw new EJBException("Facility ID = " + ejb.getParentFacilityId() + " not created.");
                    }
                }
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                BasicAttributes attrs = new BasicAttributes();
                attrs.put(OBJECTCLASS, OBJECT_CLASS_FACILITY_TREE);
                attrs.put("ccFacilityId", ejb.getFacilityId());
                attrs.put("ccTreeType", ejb.getTreeType().toString());
                attrs.put("ccFacilitySortValue", ejb.getSortValue().toString());
                attrs.put("ccFacilityBuiltIn", "FALSE");
                attrs.put("ccValid", ejb.getValid().toString().toUpperCase());
                StringBuffer dn = new StringBuffer();
                dn.append("ccFacilityId");
                dn.append("=");
                dn.append(ejb.getFacilityId());
                dn.append(",");
                dn.append(baseDn);
                ejb.setDn(dn.toString());
                timer = TimeKeeperService.start();
                ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
                pk = new FacilityTreePK(ejb.getDn());
                Object var10_9 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block20;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                }
                {
                    break block20;
                    catch (NamingException ex) {
                        m_log.debug((Object)("create(): catch NamingException" + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            AplLogger apllog = new AplLogger("REP", "rep");
                            Object[] args = new String[]{ejb.getDn()};
                            apllog.put("SYS", "007", args);
                            throw new EJBException((Exception)ex);
                        }
                        var10_9 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop(timer);
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"remove() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var10_9 = null;
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                        }
                        TimeKeeperService.stop(timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop(timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return pk;
        }
        return pk;
    }

    public Collection findAll() throws FinderException {
        return this.findAll(null, null);
    }

    public Collection findAll(String facilityId) throws FinderException {
        return this.findAll(facilityId, null);
    }

    public Collection findAllNode(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(1));
    }

    public Collection findAllScope(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findAll(String facilityId, Integer type) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findAll() : FacilityId = " + facilityId + ", Type = " + type));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.debug((Object)("findAllScope() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                m_log.debug((Object)("findAllScope() :" + e.getMessage()));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        if (type != null && type == 1) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(1);
        } else if (type != null && type == 0) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(0);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block36: {
                NamingException e222;
                Object var14_15;
                block34: {
                    timer = null;
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    timer = TimeKeeperService.start();
                    results = ctx.search(baseDn.toString(), search.toString(), constraints);
                    if (results != null) break block34;
                    m_log.debug((Object)("findAll() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    var14_15 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = null;
                    pk = aResult.getName().compareTo("") == 0 ? new FacilityTreePK(baseDn.toString()) : new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
                var14_15 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block36;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                }
                {
                    break block36;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findAllScope() : " + ex.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var14_15 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException e3) {
                        m_log.debug((Object)"findAllScope() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e3);
                        }
                        var14_15 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacilityTreePK findByPrimaryKey(FacilityTreePK pk) throws FinderException {
        Context ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            NamingException e2;
            Object var8_8;
            TimeKeeper timer;
            block19: {
                timer = null;
                m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                if (attrs == null) break block19;
                FacilityTreePK facilityTreePK = pk;
                var8_8 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e2) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                return facilityTreePK;
            }
            try {
                try {
                    throw new FinderException("FacilityTreeDAOImpl.findByPrimaryKey() : dn=" + pk.getDn() + " not found.");
                }
                catch (NamingException ex) {
                    if (ex instanceof CommunicationException) {
                        LdapConnectionManager.getConnectionManager().setDirContext(null);
                    }
                    m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)ex);
                    }
                    var8_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                }
                catch (NullPointerException ex) {
                    m_log.debug((Object)"findByPrimaryKey() : LDAP query result is null");
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)ex);
                    }
                    var8_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e2) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                }
                TimeKeeperService.stop(timer);
                throw throwable;
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findChildren(FacilityTreePK pk) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findChildren() : dn = " + pk.getDn()));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block29: {
                NamingException e222;
                Object var12_12;
                block27: {
                    timer = null;
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    timer = TimeKeeperService.start();
                    results = ctx.search(pk.getDn(), search.toString(), constraints);
                    if (results != null) break block27;
                    m_log.warn((Object)("findChildren() : No Search Result : dn = " + pk.getDn()));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    var12_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findChildren() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK p = new FacilityTreePK(aResult.getName() + "," + pk.getDn());
                    ret.add(p);
                }
                var12_12 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block29;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findChildren() context close failed : " + e222.getMessage()));
                }
                {
                    break block29;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findChildren() : " + ex.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var12_12 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findChildren() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        m_log.debug((Object)"findChildren() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var12_12 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findChildren() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findChildren() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FacilityTreePK findScopeByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findScopeByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        search.append(")(");
        search.append("ccTreeType");
        search.append("=");
        search.append(0);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        FacilityTreePK pk = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block25: {
                timer = null;
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(BASE_DN, search.toString(), constraints);
                if (results == null) {
                    throw new FinderException("FacilityTreeDAOImpl.findScopeByFacilityId() : FacilityId=" + facilityId + " not found.");
                }
                SearchResult aResult = null;
                Attributes attrs = null;
                if (results.hasMoreElements()) {
                    aResult = (SearchResult)results.nextElement();
                    attrs = aResult.getAttributes();
                }
                if (attrs == null) {
                    throw new FinderException("FacilityTreeDAOImpl.findScopeByFacilityId() : FacilityId=" + facilityId + " not found.");
                }
                pk = new FacilityTreePK(aResult.getName() + "," + BASE_DN);
                Object var12_12 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block25;
                }
                catch (NamingException e) {
                    m_log.error((Object)("findScopeByFacilityId() context close failed : " + e.getMessage()));
                }
                {
                    break block25;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findScopeByFacilityId() : " + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var12_12 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e) {
                            m_log.error((Object)("findScopeByFacilityId() context close failed : " + e.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        m_log.debug((Object)"findScopeByFacilityId() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var12_12 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e) {
                            m_log.error((Object)("findScopeByFacilityId() context close failed : " + e.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e) {
                        m_log.error((Object)("findScopeByFacilityId() context close failed : " + e.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return pk;
        }
        return pk;
    }

    public Collection findByFacilityId(String facilityId) throws FinderException {
        return this.findByFacilityId(facilityId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findByFacilityId(String facilityId, Boolean valid) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        if (valid != null) {
            search.append(")(");
            search.append("ccValid");
            search.append("=");
            search.append(valid.toString().toUpperCase());
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block30: {
                NamingException e222;
                Object var13_13;
                block28: {
                    timer = null;
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    timer = TimeKeeperService.start();
                    results = ctx.search(BASE_DN, search.toString(), constraints);
                    if (results != null) break block28;
                    m_log.warn((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    var13_13 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + BASE_DN);
                    ret.add(pk);
                }
                var13_13 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block30;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                }
                {
                    break block30;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByFacilityId() : " + ex.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var13_13 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        m_log.debug((Object)"findByFacilityId() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var13_13 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return ret;
        }
        LdapConnectionManager.getConnectionManager().setDirContext(null);
        throw new FinderException("findByFacilityId() : LDAP query result is null for many times");
    }

    public Collection findOneLevel() throws FinderException {
        return this.findOneLevel(null, null);
    }

    public Collection findOneLevel(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, null);
    }

    public Collection findOneLevelNode(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, new Integer(1));
    }

    public Collection findOneLevelScope(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findOneLevel(String facilityId, Integer type) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findOneLevel() : FacilityId = " + facilityId + ", Type = " + type));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.debug((Object)("findOneLevel() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        if (type != null && type == 1) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(1);
        } else if (type != null && type == 0) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(0);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block36: {
                NamingException e222;
                Object var14_15;
                block34: {
                    timer = null;
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    timer = TimeKeeperService.start();
                    results = ctx.search(baseDn.toString(), search.toString(), constraints);
                    if (results != null) break block34;
                    m_log.warn((Object)("findOneLevel() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    var14_15 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findOneLevel() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
                var14_15 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block36;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findOneLevel() context close failed : " + e222.getMessage()));
                }
                {
                    break block36;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findOneLevel() : " + ex.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var14_15 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findOneLevel() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        m_log.debug((Object)"findOneLevel() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var14_15 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findOneLevel() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findOneLevel() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return ret;
        }
        return ret;
    }

    public Collection findAllNodeByValid(String facilityId, Boolean valid) throws FinderException {
        return this.findNodeListByValid(facilityId, 0, valid);
    }

    public Collection findOneLevelNodeByValid(String facilityId, Boolean valid) throws FinderException {
        return this.findNodeListByValid(facilityId, 1, valid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Collection findNodeListByValid(String facilityId, int level, Boolean valid) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findAllNodeByValid() : FacilityId = " + facilityId + ", Valid = " + valid));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.debug((Object)("findAllNodeByValid() : No Search Result : FacilityId = " + facilityId + ", Valid = " + valid));
                m_log.debug((Object)("findAllNodeByValid() :" + e.getMessage()));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        if (level == 0) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccTreeType");
        search.append("=");
        search.append(1);
        search.append(")(");
        search.append("ccValid");
        search.append("=");
        search.append(valid.toString().toUpperCase());
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block35: {
                NamingException e222;
                Object var15_16;
                block33: {
                    timer = null;
                    timer = TimeKeeperService.start();
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    results = ctx.search(baseDn.toString(), search.toString(), constraints);
                    if (results != null) break block33;
                    m_log.warn((Object)("findAllNodeByValid() : No Search Result : FacilityId = " + facilityId + ", Valid = " + valid));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    var15_16 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findNodeListByValid() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
                var15_16 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block35;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findNodeListByValid() context close failed : " + e222.getMessage()));
                }
                {
                    break block35;
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findNodeListByValid() : " + ex.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var15_16 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findNodeListByValid() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        m_log.debug((Object)"findNodeListByValid() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var15_16 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findNodeListByValid() context close failed : " + e222.getMessage()));
                        }
                        TimeKeeperService.stop((TimeKeeper)timer);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var15_16 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findNodeListByValid() context close failed : " + e222.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    throw throwable;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return ret;
        }
        return ret;
    }

    public String booleanToString(Boolean value) {
        String ret = null;
        ret = value != false ? "TRUE" : "FALSE";
        return ret;
    }

    protected void clearBean(FacilityTreeBean ejb) {
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setParentFacilityId(null);
        ejb.setTreeType(null);
    }
}

