/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoUtil;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerUtil;
import com.clustercontrol.notify.util.InhibitAction;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.util.Messages;
import com.sun.mail.smtp.SMTPAddressFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMail
extends InhibitAction {
    protected static Log m_log = LogFactory.getLog(SendMail.class);
    private static final String SUBJECT_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static String FROM_ADDRESS = null;
    private static String FROM_PERSONAL_NAME = null;
    private static String REPLY_TO_ADDRESS = null;
    private static String REPLY_TO_PERSONAL_NAME = null;
    private static String ERRORS_TO_ADDRESS = null;
    private static int RETRY_COUNT = 0;
    private Locale m_local = Locale.getDefault();

    public synchronized void sendMail(OutputNotifyGroupInfo outputInfo) throws UnsupportedEncodingException, RemoteException, NamingException, MessagingException, CreateException, FinderException {
        NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(outputInfo.getNotifyId());
        NotifyMailInfoLocal mailInfo = NotifyMailInfoUtil.getLocalHome().findByPrimaryKey(new NotifyMailInfoPK(outputInfo.getNotifyId(), outputInfo.getPriority()));
        if (mailInfo == null) {
            m_log.debug((Object)"onMessage() : \u51fa\u529b\u3059\u308b\u91cd\u8981\u5ea6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (mailInfo.getMailFlg() == 1) {
            boolean isRun = false;
            if (mailInfo.getMailInhibitionFlg() == 1 && mailInfo.getMailInhibitionFlg() != 0) {
                try {
                    boolean isInhibit = super.isInhibit(outputInfo, notifyInfo);
                    if (!isInhibit) {
                        isRun = true;
                    }
                }
                catch (NumberFormatException e) {
                    m_log.error((Object)("sendMail() : " + e.getMessage()), (Throwable)e);
                }
                catch (RemoteException e) {
                    m_log.error((Object)("sendMail() : " + e.getMessage()), (Throwable)e);
                }
                catch (CreateException e) {
                    m_log.error((Object)("sendMail() : " + e.getMessage()), (Throwable)e);
                }
            } else {
                isRun = true;
            }
            if (isRun) {
                String address = mailInfo.getMailAddress();
                StringTokenizer t = new StringTokenizer(address, ";");
                ArrayList<String> addressList = new ArrayList<String>();
                while (t.hasMoreTokens()) {
                    addressList.add(t.nextToken());
                }
                String[] addresses = addressList.toArray(new String[0]);
                if (addresses == null || addresses.length <= 0) {
                    m_log.debug((Object)"onMessage() : \u901a\u77e5\u3059\u308b\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    return;
                }
                this.sendMail(addresses, outputInfo, mailInfo);
            }
        }
    }

    public boolean sendMail(String[] address, OutputNotifyGroupInfo source, NotifyMailInfoLocal mailInfo) throws NamingException, MessagingException, UnsupportedEncodingException, CreateException, FinderException, RemoteException {
        if (address == null || address.length <= 0) {
            return false;
        }
        InitialContext initialContext = null;
        try {
            InternetAddress[] toAddress;
            InternetAddress[] reply;
            initialContext = new InitialContext();
            boolean retryFlg = true;
            Session session = (Session)initialContext.lookup("java:/Mail");
            MimeMessage mes = new MimeMessage(session);
            if (FROM_ADDRESS != null && FROM_PERSONAL_NAME != null) {
                mes.setFrom((Address)new InternetAddress(FROM_ADDRESS, FROM_PERSONAL_NAME, "iso-2022-jp"));
            } else if (FROM_ADDRESS != null && FROM_PERSONAL_NAME == null) {
                mes.setFrom((Address)new InternetAddress(FROM_ADDRESS));
            }
            if (REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME != null) {
                reply = new InternetAddress[]{new InternetAddress(REPLY_TO_ADDRESS, REPLY_TO_PERSONAL_NAME, "iso-2022-jp")};
                mes.setReplyTo((Address[])reply);
                mes.reply(true);
            } else if (REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME == null) {
                reply = new InternetAddress[]{new InternetAddress(REPLY_TO_ADDRESS)};
                mes.setReplyTo((Address[])reply);
                mes.reply(true);
            }
            if (ERRORS_TO_ADDRESS != null) {
                mes.setHeader("Errors-To", ERRORS_TO_ADDRESS);
            }
            if ((toAddress = this.getAddress(address)) == null || toAddress.length <= 0) {
                return false;
            }
            mes.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            mes.setSubject(MimeUtility.encodeText((String)this.getSubject(source, mailInfo), (String)"iso-2022-jp", (String)"B"));
            mes.setContent((Object)this.getText(source, mailInfo), "text/plain; charset=iso-2022-jp");
            mes.setSentDate(this.getSentDate(source.getOutputDate()));
            for (int i = 0; i < RETRY_COUNT + 1 && retryFlg; ++i) {
                try {
                    Transport.send((Message)mes);
                    retryFlg = false;
                    continue;
                }
                catch (AuthenticationFailedException e) {
                    throw e;
                }
                catch (SMTPAddressFailedException e) {
                    throw e;
                }
                catch (MessagingException me) {
                    retryFlg = true;
                    if (i < RETRY_COUNT) {
                        m_log.debug((Object)"sendMail() : \u30e1\u30fc\u30eb\u518d\u9001\u4fe1\u51e6\u7406");
                        continue;
                    }
                    throw me;
                }
            }
            return true;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
    }

    private InternetAddress[] getAddress(String[] address) {
        Object[] toAddress = null;
        Vector<InternetAddress> list = new Vector<InternetAddress>();
        if (address != null) {
            for (int index = 0; index < address.length; ++index) {
                try {
                    list.add(new InternetAddress(address[index]));
                    continue;
                }
                catch (AddressException ae) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                toAddress = new InternetAddress[list.size()];
                list.copyInto(toAddress);
            }
        }
        return toAddress;
    }

    private String getSubject(OutputNotifyGroupInfo source, NotifyMailInfoLocal mailInfo) throws CreateException, NamingException, FinderException, RemoteException {
        String subject = null;
        if (source instanceof OutputNotifyGroupInfo) {
            try {
                if (mailInfo.getMailTemplateId() != null) {
                    MailTemplateInfoData mailData = MailTemplateControllerUtil.getLocalHome().create().getMailTemplateInfo(mailInfo.getMailTemplateId());
                    subject = SendMail.substitution(mailData.getSubject(), source);
                } else {
                    subject = Messages.getString((String)"mail.subject", (Locale)this.m_local) + "(" + PriorityConstant.typeToString((int)source.getPriority()) + ")";
                }
            }
            catch (CreateException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (FinderException e) {
                throw e;
            }
        }
        return subject;
    }

    private String getText(OutputNotifyGroupInfo source, NotifyMailInfoLocal mailInfo) throws CreateException, NamingException, FinderException, RemoteException {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
        if (source instanceof OutputNotifyGroupInfo) {
            try {
                if (mailInfo.getMailTemplateId() != null) {
                    MailTemplateInfoData mailData = MailTemplateControllerUtil.getLocalHome().create().getMailTemplateInfo(mailInfo.getMailTemplateId());
                    buf.append(SendMail.substitution(mailData.getBody(), source));
                } else {
                    buf.append(Messages.getString((String)"generation.time", (Locale)this.m_local) + " : " + sdf.format(source.getGenerationDate()) + "\n");
                    buf.append(Messages.getString((String)"application", (Locale)this.m_local) + " : " + source.getApplication() + "\n");
                    buf.append(Messages.getString((String)"priority", (Locale)this.m_local) + " : " + PriorityConstant.typeToString((int)source.getPriority()) + "\n");
                    buf.append(Messages.getString((String)"message", (Locale)this.m_local) + " : " + source.getMessage() + "\n");
                    buf.append(Messages.getString((String)"scope", (Locale)this.m_local) + " : " + source.getScopeText() + "\n");
                }
            }
            catch (CreateException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (FinderException e) {
                throw e;
            }
        }
        return buf.toString();
    }

    public static synchronized String substitution(String text, OutputNotifyGroupInfo info) {
        SimpleDateFormat sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
        String retText = text.replaceAll("\\$\\{APPLICATION\\}", SendMail.toLiteral(info.getApplication()));
        retText = retText.replaceAll("\\$\\{FACILITY_ID\\}", SendMail.toLiteral(info.getFacilityId()));
        retText = retText.replaceAll("\\$\\{MONITOR_ID\\}", SendMail.toLiteral(info.getMonitorId()));
        retText = retText.replaceAll("\\$\\{GENERATION_DATE\\}", SendMail.toLiteral(sdf.format(info.getGenerationDate())));
        retText = retText.replaceAll("\\$\\{PLUGIN_ID\\}", SendMail.toLiteral(info.getPluginId()));
        retText = retText.replaceAll("\\$\\{PRIORITY\\}", SendMail.toLiteral(PriorityConstant.typeToString((int)info.getPriority())));
        retText = retText.replaceAll("\\$\\{PRIORITY_JP\\}", SendMail.toLiteral(PriorityConstant.typeToStringJP((int)info.getPriority())));
        retText = retText.replaceAll("\\$\\{PRIORITY_EN\\}", SendMail.toLiteral(PriorityConstant.typeToStringEN((int)info.getPriority())));
        retText = retText.replaceAll("\\$\\{PRIORITY_NUM\\}", SendMail.toLiteral(String.valueOf(info.getPriority())));
        retText = retText.replaceAll("\\$\\{SCOPE\\}", SendMail.toLiteral(info.getScopeText()));
        retText = retText.replaceAll("\\$\\{MESSAGE_ID\\}", SendMail.toLiteral(info.getMessageId()));
        retText = retText.replaceAll("\\$\\{MESSAGE\\}", SendMail.toLiteral(info.getMessage()));
        retText = retText.replaceAll("\\$\\{ORG_MESSAGE\\}", SendMail.toLiteral(info.getMessageOrg()));
        try {
            if (retText.indexOf("${IP_ADDRESS}") != -1 || retText.indexOf("${NODE}") != -1) {
                FacilityLocal facility;
                String nodeName = null;
                String ipNetworkNumber = null;
                String facilityId = info.getFacilityId();
                if (facilityId != null && !facilityId.equals("") && (facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId)) != null) {
                    nodeName = facility.getNodeName();
                    int version = 4;
                    if (facility.getIpProtocolNumber() != null) {
                        version = facility.getIpProtocolNumber();
                    }
                    ipNetworkNumber = version == 4 ? facility.getIpNetworkNumber() : facility.getIpNetworkNumberV6();
                }
                if (nodeName != null && !nodeName.equals("")) {
                    retText = retText.replaceAll("\\$\\{NODE\\}", SendMail.toLiteral(nodeName));
                }
                if (ipNetworkNumber != null && !ipNetworkNumber.equals("")) {
                    retText = retText.replaceAll("\\$\\{IP_ADDRESS\\}", SendMail.toLiteral(ipNetworkNumber));
                }
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("substitution() : " + e.getMessage()), (Throwable)e);
        }
        catch (FinderException e) {
            m_log.error((Object)("substitution() : " + e.getMessage()), (Throwable)e);
        }
        return retText;
    }

    private static String toLiteral(String text) {
        if (text == null) {
            return "";
        }
        if (text.indexOf(92) == -1 && text.indexOf(36) == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                buffer.append('\\');
                continue;
            }
            if (c == '$') {
                buffer.append('\\');
                buffer.append('$');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private Date getSentDate(Date timeStamp) {
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        return timeStamp;
    }

    static {
        Properties properties = new Properties();
        try {
            String etcdir = System.getProperty("hinemos.manager.etc.dir");
            String propertyFile = etcdir + File.separator + "hinemos.properties";
            properties.load(new FileInputStream(propertyFile));
            FROM_ADDRESS = properties.getProperty("common.mail.from.address");
            FROM_PERSONAL_NAME = properties.getProperty("common.mail.from.personal.name");
            REPLY_TO_ADDRESS = properties.getProperty("common.mail.reply.to.address");
            REPLY_TO_PERSONAL_NAME = properties.getProperty("common.mail.reply.personal.name");
            ERRORS_TO_ADDRESS = properties.getProperty("common.mail.errors.to.address");
            RETRY_COUNT = Integer.parseInt(properties.getProperty("common.mail.retry.count"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

