/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.http;

import java.util.HashMap;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.samples.http.ComplexObject;

public class SimpleClient {
    private static String transport = "http";
    private static String host = "localhost";
    private static int port = 5400;

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        Client remotingClient = new Client(locator);
        remotingClient.connect();
        Object response = remotingClient.invoke(new ComplexObject(2, "foo", true), null);
        System.out.println("\nResponse from remoting http server when making http POST request and sending a complex data object:\n" + response);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("TYPE", "GET");
        response = remotingClient.invoke((Object)null, metadata);
        System.out.println("\nResponse from remoting http server when making GET request:\n" + response);
        metadata.put("TYPE", "POST");
        response = remotingClient.invoke("return_string", metadata);
        System.out.println("\nResponse from remoting http server when making http POST request and sending a text based request:\n" + response);
        Integer responseCode = (Integer)metadata.get("ResponseCode");
        String responseMessage = (String)metadata.get("ResponseCodeMessage");
        System.out.println("Response code from server: " + responseCode);
        System.out.println("Response message from server: " + responseMessage);
    }

    public static void main(String[] args) {
        if (args != null && args.length == 3) {
            transport = args[0];
            host = args[1];
            port = Integer.parseInt(args[2]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        SimpleClient client = new SimpleClient();
        try {
            client.makeInvocation(locatorURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

