/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;
import com.clustercontrol.performance.operator.Operator;
import com.clustercontrol.performance.operator.Undefined;
import com.clustercontrol.sharedtable.DataTable;
import java.util.HashMap;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CalculationMethod {
    private static Log m_log = LogFactory.getLog(CalculationMethod.class);
    private static Object modifyLock = new Object();
    private static final String DEFAULT_METHOD_CLASS_PACKAGE = "com.clustercontrol.performance.operator";
    private static HashMap<CollectorItemCalcMethodMstPK, Operator> m_operationMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getPerformance(String platformId, String subPlatformId, CollectorItemInfo itemInfo, CollectorDeviceInfoData deviceData, DataTable currentTable, DataTable previousTable) {
        try {
            CollectorItemCodeMstLocal itemCodeMst = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(itemInfo.getItemCode());
            CollectorCategoryCollectMstPK collectPk = new CollectorCategoryCollectMstPK(platformId, subPlatformId, itemCodeMst.getCategoryCode());
            CollectorCategoryCollectMstLocal collect = CollectorCategoryCollectMstUtil.getLocalHome().findByPrimaryKey(collectPk);
            CollectorItemCalcMethodMstPK pk = new CollectorItemCalcMethodMstPK(collect.getCollectMethod(), platformId, subPlatformId, itemInfo.getItemCode());
            Operator ope = m_operationMap.get(pk);
            if (ope == null) {
                CalculationMethod.registerOperation(pk);
                ope = m_operationMap.get(pk);
                if (ope == null) {
                    return Double.NaN;
                }
            }
            Operator operator = ope;
            synchronized (operator) {
                ope.setCurrentTable(currentTable);
                ope.setPreviousTable(previousTable);
                if (deviceData == null || deviceData.getIndex() == -1L) {
                    ope.setDeviceIndex(-1L);
                } else {
                    ope.setDeviceIndex(deviceData.getIndex());
                }
                if (deviceData == null || deviceData.getDeviceName().equals("")) {
                    ope.setDeviceName("");
                } else {
                    ope.setDeviceName(deviceData.getDeviceName());
                }
                return ope.calc();
            }
        }
        catch (Exception e) {
            m_log.debug((Object)e.getMessage(), (Throwable)e);
            return Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerOperation(CollectorItemCalcMethodMstPK pk) {
        Object object = modifyLock;
        synchronized (object) {
            try {
                m_log.debug((Object)("Register Operation : " + pk.getCollectMethod() + ", " + pk.getItemCode() + ", " + pk.getPlatformId() + ", " + pk.getSubPlatformId()));
                CollectorItemCalcMethodMstLocal bean = CollectorItemCalcMethodMstUtil.getLocalHome().findByPrimaryKey(pk);
                String calcMethod = bean.getCalcMethod();
                CollectorCalcMethodMstLocal methodMst = CollectorCalcMethodMstUtil.getLocalHome().findByPrimaryKey(calcMethod);
                try {
                    String className = methodMst.getClassName();
                    if (className.indexOf(46) == -1) {
                        className = "com.clustercontrol.performance.operator." + className;
                    }
                    Operator ope = (Operator)Class.forName(className).newInstance();
                    ope.setCollectMethod(bean.getCollectMethod());
                    ope.setPlatformId(bean.getPlatformId());
                    ope.setSubPlatformId(bean.getSubPlatformId());
                    ope.setItemCode(bean.getItemCode());
                    m_operationMap.put(pk, ope);
                }
                catch (ClassNotFoundException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    m_log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (FinderException e) {
                m_log.error((Object)("No such entity!  " + pk.getItemCode() + ", " + pk.getPlatformId()));
                m_operationMap.put(pk, new Undefined());
                m_log.debug((Object)e.getMessage(), (Throwable)e);
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

