/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.forward;

import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.syslogng.forward.EJBContoroller;
import com.clustercontrol.syslogng.forward.LogManager;
import com.clustercontrol.syslogng.message.UpdateMonitorRuleInfo;
import java.io.Serializable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateRepositoryInfoReceiveTopic
implements MessageListener,
ExceptionListener {
    private static Log m_log = LogFactory.getLog(UpdateRepositoryInfoReceiveTopic.class);
    private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
    private static final long RETRY_INTERVAL = 10000L;
    private static final String MULTI_ID = "multi.id";
    protected LogManager m_logmanager;
    private TopicConnectionFactory m_factory;
    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    protected EJBContoroller m_ejbContoroler;
    private Properties m_props;
    private boolean m_errFlg = false;
    protected Timer m_timer = new Timer(true);
    private Object reconnectLock = new Object();

    public UpdateRepositoryInfoReceiveTopic(LogManager logmanager, EJBContoroller ejbContoroler, Properties props) {
        this.m_logmanager = logmanager;
        this.m_props = props;
        this.m_ejbContoroler = ejbContoroler;
        this.initial();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        Serializable obj;
        if (!(message instanceof ObjectMessage)) return;
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            obj = objectMessage.getObject();
        }
        catch (JMSException e) {
            return;
        }
        if (obj instanceof UpdateRepositoryInfo) {
            m_log.debug((Object)"onMessage : Receive UpdateRepositoryInfo");
            this.m_ejbContoroler.loadFilterInfo();
            return;
        } else {
            if (!(obj instanceof UpdateMonitorRuleInfo)) return;
            m_log.debug((Object)"onMessage : Receive UpdateMonitorRuleInfo");
            this.m_ejbContoroler.loadFilterInfo();
        }
    }

    public void onException(JMSException arg0) {
        m_log.error((Object)arg0.getMessage(), (Throwable)arg0);
        this.m_logmanager.reConnection();
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            this.m_timer.schedule((TimerTask)new ReSetupTask(), 10000L, 10000L);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        m_log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            m_log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.setErrFlg(false);
        } else {
            m_log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        this.terminateSumscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
            m_log.debug((Object)"Session close was successful.");
        }
        catch (JMSException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
            m_log.debug((Object)"Connection close was successful.");
        }
        catch (JMSException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void terminateSumscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (TopicConnectionFactory)con.lookup(TOPIC_CON_FACTORY);
            this.m_con = this.m_factory.createTopicConnection();
            this.m_session = this.m_con.createTopicSession(false, 1);
            this.m_topic = (Topic)con.lookup("topic/clustercontrolRepositoryUpdate");
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.initialTopic();
        }
        catch (Exception e) {
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialTopic() {
        this.terminateSumscriber();
        try {
            StringBuffer msgSelector = new StringBuffer();
            String multiId = this.m_props.getProperty(MULTI_ID, null);
            if (multiId != null && multiId.length() > 0) {
                msgSelector.append("MultiId='");
                msgSelector.append(multiId);
                msgSelector.append("' OR All='true'");
            }
            if (msgSelector.length() != 0) {
                this.m_subscriber = this.m_session.createSubscriber(this.m_topic, msgSelector.toString(), false);
                this.m_subscriber.setMessageListener((MessageListener)this);
            } else {
                this.m_subscriber = this.m_session.createSubscriber(this.m_topic);
                this.m_subscriber.setMessageListener((MessageListener)this);
            }
        }
        catch (Exception e) {
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.reconnectLock;
        synchronized (object) {
            this.setErrFlg(true);
            this.terminate();
        }
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            m_log.info((Object)"timer task");
            if (UpdateRepositoryInfoReceiveTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

