/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.monitor.alarm.AlarmNotification;
import org.jboss.monitor.alarm.AlarmTableNotification;
import org.jboss.monitor.alarm.MBeanImplAccess;
import org.jboss.system.ServiceMBeanSupport;

public class AlarmTable {
    protected MBeanImplAccess mbeanImpl;
    private String serverId;
    private SynchronizedLong alarmIdCount;
    private Map alarmMap;
    private Map statefulMap;
    private int maxSize = -1;

    public AlarmTable(MBeanImplAccess mbeanImpl) {
        this.mbeanImpl = mbeanImpl;
        this.alarmIdCount = new SynchronizedLong(0L);
        this.alarmMap = new LinkedHashMap();
        this.statefulMap = new HashMap();
    }

    public AlarmTable(final ServiceMBeanSupport service) {
        this(new MBeanImplAccess(){

            public ObjectName getMBeanName() {
                return service.getServiceName();
            }

            public long getSequenceNumber() {
                return service.nextNotificationSequenceNumber();
            }

            public void emitNotification(Notification n) {
                service.sendNotification(n);
            }
        });
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void update(Notification n) {
        if (!(n instanceof AlarmTableNotification)) {
            if (n instanceof AlarmNotification) {
                AlarmNotification an = (AlarmNotification)n;
                if (an.getAlarmState() == 3) {
                    this.updateNotificationStateless(n, an.getSeverity());
                } else {
                    this.updateNotificationStatefull(an);
                }
            } else {
                this.updateNotificationStateless(n, 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledge(String alarmId, String user, String system) {
        AlarmTableNotification atn;
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            AlarmTableNotification entry = (AlarmTableNotification)this.alarmMap.get(alarmId);
            if (entry == null || entry.getAckState()) {
                return false;
            }
            entry.setAckParams(true, System.currentTimeMillis(), user, system);
            atn = new AlarmTableNotification(entry);
            atn.setSequenceNumber(this.mbeanImpl.getSequenceNumber());
            atn.setTimeStamp(System.currentTimeMillis());
            int alarmState = entry.getAlarmState();
            if (alarmState == 3 || alarmState == 0) {
                this.alarmMap.remove(alarmId);
            }
        }
        this.mbeanImpl.emitNotification(atn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unacknowledge(String alarmId, String user, String system) {
        AlarmTableNotification atn;
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            AlarmTableNotification entry = (AlarmTableNotification)this.alarmMap.get(alarmId);
            if (entry == null || !entry.getAckState()) {
                return false;
            }
            entry.setAckParams(false, System.currentTimeMillis(), user, system);
            atn = new AlarmTableNotification(entry);
            atn.setSequenceNumber(this.mbeanImpl.getSequenceNumber());
            atn.setTimeStamp(System.currentTimeMillis());
        }
        this.mbeanImpl.emitNotification(atn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmTableNotification[] getAlarmTable() {
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            Collection alarms = this.alarmMap.values();
            AlarmTableNotification[] array = new AlarmTableNotification[alarms.size()];
            return alarms.toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlarmSize() {
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            return this.alarmMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationStatefull(AlarmNotification an) {
        AlarmTableNotification atn;
        int alarmState = an.getAlarmState();
        int severity = an.getSeverity();
        Object alarmKey = AlarmNotification.createKey(an);
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            String alarmId = (String)this.statefulMap.get(alarmKey);
            if (alarmId == null) {
                if (this.isMaxSizeReached()) {
                    return;
                }
                alarmId = this.generateAlarmId();
            }
            atn = new AlarmTableNotification(alarmId, "jboss.alarm.table.update", this.mbeanImpl.getMBeanName(), null, severity, alarmState, this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), null);
            atn.setUserData(an);
            if (alarmState == 0) {
                AlarmTableNotification entry = (AlarmTableNotification)this.alarmMap.get(alarmId);
                if (entry != null && entry.getAckState()) {
                    this.statefulMap.remove(alarmKey);
                    this.alarmMap.remove(alarmId);
                    atn.setAckParams(true, entry.getAckTime(), entry.getAckUser(), entry.getAckSystem());
                } else {
                    this.statefulMap.put(alarmKey, alarmId);
                    this.alarmMap.put(alarmId, atn);
                }
            } else {
                this.statefulMap.put(alarmKey, alarmId);
                this.alarmMap.put(alarmId, atn);
            }
        }
        if (atn.getAckState()) {
            this.mbeanImpl.emitNotification(atn);
        } else {
            this.mbeanImpl.emitNotification(new AlarmTableNotification(atn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationStateless(Notification n, int severity) {
        AlarmTable alarmTable = this;
        synchronized (alarmTable) {
            if (this.isMaxSizeReached()) {
                return;
            }
        }
        AlarmTableNotification atn = new AlarmTableNotification(this.generateAlarmId(), "jboss.alarm.table.update", this.mbeanImpl.getMBeanName(), null, severity, 3, this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), null);
        atn.setUserData(n);
        AlarmTable alarmTable2 = this;
        synchronized (alarmTable2) {
            this.alarmMap.put(atn.getAlarmId(), atn);
        }
        this.mbeanImpl.emitNotification(new AlarmTableNotification(atn));
    }

    private String generateAlarmId() {
        return this.serverId + '-' + this.alarmIdCount.increment();
    }

    private boolean isMaxSizeReached() {
        if (this.maxSize != -1) {
            return this.alarmMap.size() >= this.maxSize;
        }
        return false;
    }
}

