/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmKey;

public class AlarmNotification
extends Notification {
    private static final long serialVersionUID = -7041616127511632675L;
    private ObjectName target;
    private int severity;
    private int alarmState;

    public AlarmNotification(String type, Object source, ObjectName target, int severity, int alarmState, long sequenceNumber, long timeStamp, String message) {
        super(type, source, sequenceNumber, timeStamp, message);
        this.target = target;
        switch (alarmState) {
            case 0: {
                this.alarmState = 0;
                this.severity = 0;
                break;
            }
            case 1: 
            case 2: {
                this.alarmState = alarmState;
                if (severity > 0 && severity <= 5) {
                    this.severity = severity;
                    break;
                }
                this.severity = 5;
                break;
            }
            default: {
                this.alarmState = 3;
                this.severity = severity >= 0 && severity <= 5 ? severity : 5;
            }
        }
    }

    public static Object createKey(Notification n) {
        Object source = AlarmNotification.getEffectiveSource(n);
        return AlarmKey.createKey(source, n.getType());
    }

    public static Object getEffectiveSource(Notification n) {
        ObjectName target;
        Object source = n.getSource();
        if (n instanceof AlarmNotification && (target = ((AlarmNotification)n).getTarget()) != null) {
            source = target;
        }
        return source;
    }

    public ObjectName getTarget() {
        return this.target;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getAlarmState() {
        return this.alarmState;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append(AlarmNotification.class.getName());
        sbuf.append(" [ type=").append(this.getType());
        sbuf.append(", source=").append(this.getSource());
        sbuf.append(", target=").append(this.target);
        sbuf.append(", severity=").append(Alarm.SEVERITY_STRINGS[this.severity]);
        sbuf.append(", alarmState=").append(Alarm.STATE_STRINGS[this.alarmState]);
        sbuf.append(", sequenceNumber=").append(this.getSequenceNumber());
        sbuf.append(", timeStamp=").append(this.getTimeStamp());
        sbuf.append(", message=").append(this.getMessage());
        sbuf.append(", userData={").append(this.getUserData());
        sbuf.append("} ]");
        return sbuf.toString();
    }
}

